//                                               -*- C++ -*-
/**
 *  @file  MonteCarlo.cxx
 *  @brief MonteCarlo is an implementation of the hit or miss Monte Carlo simulation method
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: MonteCarlo.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "MonteCarlo.hxx"
#include "ComparisonOperatorImplementation.hxx"
#include "PersistentObjectFactory.hxx"

BEGIN_NAMESPACE_OPENTURNS



/*
 * @class MonteCarlo
 */

CLASSNAMEINIT(MonteCarlo);

static Factory<MonteCarlo> RegisteredFactory("MonteCarlo");

/* Constructor with parameters */
MonteCarlo::MonteCarlo(const Event & event):
  Simulation(event)
{
  // Nothing to do
}

/* Virtual constructor */
MonteCarlo * MonteCarlo::clone() const
{
  return new MonteCarlo(*this);
}

/* Compute the block sample */
NumericalSample MonteCarlo::computeBlockSample()
{
  return event_.getNumericalSample(blockSize_);
}

/* String converter */
String MonteCarlo::__repr__() const
{
  OSS oss;
  oss << "class=" << MonteCarlo::GetClassName()
      << " derived from " << Simulation::__repr__();
  return oss;
}

END_NAMESPACE_OPENTURNS
