//                                               -*- C++ -*-
/**
 *  @file  BernoulliFactory.hxx
 *  @brief Factory for Bernoulli distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: BernoulliFactory.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_BERNOULLIFACTORY_HXX
#define OPENTURNS_BERNOULLIFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Bernoulli.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class BernoulliFactory
 */
class BernoulliFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  BernoulliFactory();

  /** Virtual constructor */
  virtual BernoulliFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;
  Bernoulli * build(const NumericalSample & sample) const;
  Bernoulli * build(const NumericalPointCollection & parameters) const;
  Bernoulli * build() const;


}; /* class BernoulliFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_BERNOULLIFACTORY_HXX */
