//                                               -*- C++ -*-
/**
 *  @file  UniformFactory.hxx
 *  @brief Factory for Uniform distribution
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: UniformFactory.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_UNIFORMFACTORY_HXX
#define OPENTURNS_UNIFORMFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"
#include "Uniform.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class UniformFactory
 */
class UniformFactory
  : public DistributionImplementationFactory
{
public:

  /** Default constructor */
  UniformFactory();

  /** Virtual constructor */
  UniformFactory * clone() const;

  /* Here is the interface that all derived class must implement */
  using DistributionImplementationFactory::build;

  Uniform * build(const NumericalSample & sample) const;
  Uniform * build(const NumericalPointCollection & parameters) const;
  Uniform * build() const;


}; /* class UniformFactory */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_UNIFORMFACTORY_HXX */
