//                                               -*- C++ -*-
/**
 *  @file  ARMAFactory.hxx
 *  @brief The interface class that implements all process
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: ARMAFactory.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_ARMAFACTORY_HXX
#define OPENTURNS_ARMAFACTORY_HXX

#include "TypedInterfaceObject.hxx"
#include "Pointer.hxx"
#include "ARMAFactoryImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class ARMAFactory
 *
 * The class that implements all processs
 */
class ARMAFactory
  : public TypedInterfaceObject<ARMAFactoryImplementation>
{
  CLASSNAME;

public:

  /* Some typedefs for easy reading */
  typedef ARMAFactoryImplementation::Implementation Implementation;

  /** Default constructor */
  ARMAFactory();

  /** Copy constructors */
  ARMAFactory(const ARMAFactoryImplementation & implementation,
              const String & name = DefaultName);


  /** Constructor from implementation */
  ARMAFactory(const Implementation & p_implementation,
              const String & name = DefaultName);

#ifndef SWIG
  /** Constructor from implementation pointer */
  ARMAFactory(ARMAFactoryImplementation * p_implementation,
              const String & name = DefaultName);
#endif

  /** Virtual constructor */
  ARMAFactory * clone() const;

  /** String converter */
  String __repr__() const;

  /** String converter */
  String __str__(const String & offset = "") const;

  /** Build method */
  ARMA build(const TimeSeries & timeSeries) const;

  /** Build method */
  ARMA build(const ProcessSample & sample) const;


}; /* class ARMAFactory */
END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_ARMAFACTORY_HXX */
