//                                               -*- C++ -*-
/**
 *  @file  t_Curve_std.cxx
 *  @brief The test file of class Curve for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_Curve_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <cstdlib>

#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Graph.hxx"
#include "Curve.hxx"

using namespace OT;
using namespace OT::Test;
using namespace std;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    // Generate the data for the curves to be drawn
    UnsignedLong size = 50;
    NumericalPoint cursor(2);

    NumericalSample data1(size, 2); //curve y = 2x for x in [-2;5]
    NumericalSample data2(size, 2); //curve y = x*x for x in [-1;1]

    NumericalScalar tmp;
    for(UnsignedLong i=0; i<size; i++)
      {
        tmp = 7.*i/size+2;
        cursor[0] = tmp;
        cursor[1] = 2*tmp;
        data1[i] = cursor;

        tmp = 9.*i/size+1;
        cursor[0] = tmp;
        cursor[1] = tmp*tmp;
        data2[i] = cursor;
      }

    // Create an empty graph
    Graph myGraph("Some curves", "x1", "x2", true,"topright", 1.0, GraphImplementation::NONE);

    // Create the first cloud
    Curve myCurve1(data1, "blue", "dashed", 2, "linear function", true);

    // Then, draw it
    myGraph.add(myCurve1);
    myGraph.draw("Graph_Curve_a_OT", 640, 480);

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;

    // Create the second cloud
    Curve myCurve2(data2, "red", "solid", 2, "polynomial function");

    // Add it to the graph and draw everything
    myGraph.add(myCurve2);
    for (UnsignedLong i = 0; i < 4; ++i)
      {
        myGraph.setLogScale(static_cast<GraphImplementation::LogScale>(i));
        myGraph.draw(String(OSS() << "Graph_Curve_b_OT_" << i), 640, 480);
        fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
        fullprint << "postscript=" << myGraph.getPostscript() << std::endl;
      }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
