//                                               -*- C++ -*-
/**
 *  @file  t_QuadraticLeastSquares_std.cxx
 *  @brief The test file of class QuadraticLeastSquares for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_QuadraticLeastSquares_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "NumericalMathFunction.hxx"
#include "NumericalSample.hxx"
#include "NumericalPoint.hxx"
#include "QuadraticLeastSquares.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    NumericalMathFunction myFunc("TestResponseSurface");
    NumericalSample data(9, myFunc.getInputDimension());
    NumericalPoint point(myFunc.getInputDimension());
    point[0] = 0.5;
    point[1] = 0.5;
    data[0] = point;
    point[0] = -1;
    point[1] = -1;
    data[1] = point;
    point[0] = -1;
    point[1] = 1;
    data[2] = point;
    point[0] = 1;
    point[1] = -1;
    data[3] = point;
    point[0] = 1;
    point[1] = 1;
    data[4] = point;
    point[0] = -0.5;
    point[1] = -0.5;
    data[5] = point;
    point[0] = -0.5;
    point[1] = 0.5;
    data[6] = point;
    point[0] = 0.5;
    point[1] = -0.5;
    data[7] = point;
    point[0] = 0.5;
    point[1] = 0.5;
    data[8] = point;
    {
      QuadraticLeastSquares myLeastSquares(data, myFunc);
      myLeastSquares.run();
      NumericalMathFunction responseSurface(myLeastSquares.getResponseSurface());
      fullprint << "myLeastSquares=" << myLeastSquares << std::endl;
      fullprint << "responseSurface=" << responseSurface << std::endl;
      NumericalPoint in(myFunc.getInputDimension(),0.2);
      fullprint << "myFunc(" << in << ")=" << myFunc(in) << std::endl;
      fullprint << "responseSurface(" << in << ")=" << responseSurface(in) << std::endl;
    }
    {
      NumericalSample dataOut(myFunc(data));
      QuadraticLeastSquares myLeastSquares(data, dataOut);
      myLeastSquares.run();
      NumericalMathFunction responseSurface(myLeastSquares.getResponseSurface());
      fullprint << "myLeastSquares=" << myLeastSquares << std::endl;
      fullprint << "responseSurface=" << responseSurface << std::endl;
      NumericalPoint in(myFunc.getInputDimension(),0.2);
      fullprint << "myFunc(" << in << ")=" << myFunc(in) << std::endl;
      fullprint << "responseSurface(" << in << ")=" << responseSurface(in) << std::endl;
    }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
