//                                               -*- C++ -*-
/**
 *  @file  t_UserDefined_std.cxx
 *  @brief The test file of class UserDefined for standard methods
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_UserDefined_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "UserDefined.hxx"
#include "UserDefinedPair.hxx"
#include "NumericalPoint.hxx"
#include "Indices.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {
    // Instanciate one distribution object
    typedef UserDefined::UserDefinedPairCollection PairCollection;
    PairCollection collection(3);
    NumericalPoint point(1);
    point[0] = 1.0;
    collection[0] = UserDefinedPair(point, 0.3);
    point[0] = 2.0;
    collection[1] = UserDefinedPair(point, 0.1);
    point[0] = 3.0;
    collection[2] = UserDefinedPair(point, 0.6);
    UserDefined distribution(collection);
    fullprint << "Distribution " << distribution << std::endl;
    std::cout << "Distribution " << distribution << std::endl;

    // Is this distribution elliptical ?
    fullprint << "Elliptical = " << (distribution.isElliptical() ? "true" : "false") << std::endl;

    // Is this distribution continuous ?
    fullprint << "Continuous = " << (distribution.isContinuous() ? "true" : "false") << std::endl;

    // Test for realization of distribution
    NumericalPoint oneRealization = distribution.getRealization();
    fullprint << "oneRealization=" << oneRealization << std::endl;

    // Test for sampling
    UnsignedLong size = 10;
    NumericalSample oneSample = distribution.getNumericalSample( size );
    fullprint << "oneSample=" << oneSample << std::endl;

    // Define a point
    point = NumericalPoint( distribution.getDimension(), 2.0 );

    // Show PDF and CDF of a point
    NumericalScalar pointPDF = distribution.computePDF( point );
    NumericalScalar pointCDF = distribution.computeCDF( point );
    fullprint << "point= " << point
              << " pdf=" << pointPDF
              << " cdf=" << pointCDF
              << std::endl;

    // Get 95% quantile
    NumericalPoint quantile = distribution.computeQuantile( 0.95 );
    fullprint << "Quantile=" << quantile << std::endl;

    NumericalSample sample(4, 3);
    for (UnsignedLong i = 0; i < 4; ++i)
      {
        for (UnsignedLong j = 0; j < 3; ++j)
          {
            sample[i][j] = 10 * (i + 1) + 0.1 * (j+1);
          }
      }
    UserDefined multivariateUserDefined(sample);
    fullprint << "Multivariate UserDefined=" << multivariateUserDefined << std::endl;
    fullprint << "Marginal 0=" << Distribution(multivariateUserDefined.getMarginal(0)) << std::endl;
    Indices indices(2);
    indices[0] = 2;
    indices[1] = 0;
    fullprint << "Marginal (2, 0)=" << Distribution(multivariateUserDefined.getMarginal(indices)) << std::endl;

    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("distribution", distribution);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    UserDefined userDefined;
    myStudy2.fillObject("distribution", userDefined);
    fullprint << "loaded UserDefined=" << userDefined << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
