//                                               -*- C++ -*-
/**
 *  @file  t_WhiteNoise_std.cxx
 *  @brief The test file of class WhiteNoise
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: t_WhiteNoise_std.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "TimeSeries.hxx"
#include "WhiteNoise.hxx"
#include "Uniform.hxx"
#include "Process.hxx"
#include "Distribution.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    const NumericalScalar Tmin(0.0);
    const NumericalScalar deltaT(0.1);
    const UnsignedLong N(11);

    /* Initialization of the RegularGrid timeGrid1*/
    RegularGrid timeGrid(Tmin, deltaT, N);

    /* Distribution choice */
    Distribution dist = Uniform();
    fullprint << "dist = " << dist << std::endl;

    Process process = WhiteNoise(dist);

    /* Setting the timeGrid */
    process.setTimeGrid(timeGrid);

    /* Print of the process */
    fullprint << "process = " << process << std::endl;

    /* Initialization of the TimeSeries */
    TimeSeries timeSerie = process.getRealization();

    /* Full prints */
    fullprint << "timeSerie = " << timeSerie << std::endl;

    /* Tests for load and save */
    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("whiteNoise", process);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    WhiteNoise loadprocess;
    myStudy2.fillObject("whiteNoise", loadprocess);
    fullprint << "loaded white noise =" << loadprocess << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
