//                                               -*- C++ -*-
/**
 * @file  PythonNumericalMathEvaluationImplementation.hxx
 * @brief This class binds a Python function to an Open TURNS' NumericalMathFunction
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * \author $LastChangedBy: schueller $
 * \date   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 */

#ifndef OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX
#define OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX

#include "Python.h"
#include "NumericalMathEvaluationImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS


/**
 * @class PythonNumericalMathEvaluationImplementation
 *
 * This class binds a Python function to an Open TURNS' NumericalMathFunction
 */
class PythonNumericalMathEvaluationImplementation
  : public NumericalMathEvaluationImplementation
{
  CLASSNAME;
public:


  /** Constructor from Python object*/
  PythonNumericalMathEvaluationImplementation(PyObject * pyCallable);

  /** Copy constructor */
  PythonNumericalMathEvaluationImplementation(const PythonNumericalMathEvaluationImplementation & other);

  /** Virtual constructor */
  virtual PythonNumericalMathEvaluationImplementation * clone() const;

  /** Destructor */
  virtual ~PythonNumericalMathEvaluationImplementation();

  /** Comparison operator */
  Bool operator ==(const PythonNumericalMathEvaluationImplementation & other) const;

  /** String converter */
  virtual String __repr__() const;
  virtual String __str__(const String & offset) const;


  /** Test for actual implementation */
  virtual Bool isActualImplementation() const;


  /* Here is the interface that all derived class must implement */

  /** Operator () */
  virtual NumericalPoint operator() (const NumericalPoint & inP) const;
  /* throw(InvalidArgumentException,InternalException); */

  virtual NumericalSample operator() (const NumericalSample & inS) const;
  /* throw(InvalidArgumentException,InternalException); */

  /** Accessor for input point dimension */
  virtual UnsignedLong getInputDimension() const;
  /*        throw(InternalException);*/

  /** Accessor for output point dimension */
  virtual UnsignedLong getOutputDimension() const;
  /*        throw(InternalException);*/

  /** Method save() stores the object through the StorageManager */
  virtual void save(Advocate & adv) const;

  /** Method save() reloads the object from the StorageManager */
  virtual void load(Advocate & adv);

protected:


private:

  friend class Factory<PythonNumericalMathEvaluationImplementation>;

  /** Default constructor */
  PythonNumericalMathEvaluationImplementation();

  /** Handle python exceptions */
  void handleException() const;

  /** The underlying Python callable object */
  PyObject * pyObj_;

}; /* class PythonNumericalMathEvaluationImplementation */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_PYTHONNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX */
