// SWIG file algo_module.i
// Author : $LastChangedBy: schueller $
// Date : $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
// Id : $Id: algo_module.i 1649 2010-11-09 12:44:00Z dutka $

%module(package="openturns", docstring="Approximation algo_module.ithms.") algo
%feature("autodoc","1");

%{
#include "OTconfig.hxx"
#include "OTAlgo.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

/* Base/Common */
%import common_module.i

/* Wrapper */
%import wrapper_module.i
%import BaseWrapperTemplateDefs.i

/* Base/Type */
%import typ_module.i
%import BaseTypTemplateDefs.i

/* Base/Stat */
%import statistics_module.i
%import BaseStatisticsTemplateDefs.i

/* Base/Func */
%import func_module.i
%import BaseFuncTemplateDefs.i

/* Base/Algo */
%include FittingAlgorithmImplementation.i
%include FittingAlgorithm.i
%include KFold.i
%include CorrectedLeaveOneOut.i
%include ApproximationAlgorithmImplementation.i
%include ApproximationAlgorithm.i
%include ApproximationAlgorithmImplementationFactory.i
%include Lasso.i
%include LassoFactory.i
%include LeastSquaresMetaModelSelection.i
%include LeastSquaresMetaModelSelectionFactory.i
%include PenalizedLeastSquaresAlgorithm.i
%include PenalizedLeastSquaresAlgorithmFactory.i
%include FFTImplementation.i
%include FFT.i
%include KissFFT.i

/* At last we include template definitions */
%include BaseAlgoTemplateDefs.i
