//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Model
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTMODEL_HXX
#define OPENTURNS_OTMODEL_HXX

#include "ArchimedeanCopula.hxx"
#include "CompositeRandomVector.hxx"
#include "ConditionalRandomVector.hxx"
#include "ConstantRandomVector.hxx"
#include "ContinuousDistribution.hxx"
#include "Copula.hxx"
#include "CopulaImplementation.hxx"
#include "DiscreteDistribution.hxx"
#include "Distribution.hxx"
#include "DistributionFactory.hxx"
#include "DistributionImplementation.hxx"
#include "DistributionFactoryImplementation.hxx"
#include "DistributionParametersImplementation.hxx"
#include "DistributionParameters.hxx"
#include "EllipticalDistribution.hxx"
#include "Event.hxx"
#include "EventDomainImplementation.hxx"
#include "EventRandomVectorImplementation.hxx"
#include "EventProcess.hxx"
#include "FunctionalChaosRandomVector.hxx"
#include "KrigingRandomVector.hxx"
#include "ProcessImplementation.hxx"
#include "Process.hxx"
#include "RandomVector.hxx"
#include "RandomVectorImplementation.hxx"
#include "SklarCopula.hxx"
#include "StandardEvent.hxx"
#include "UsualRandomVector.hxx"

#endif /* OPENTURNS_OTMODEL_HXX */
