"computeTestTwoSampleSpearman" <-
function(numericalSample1, numericalSample2, testLevel = 0.95) {

  # Direct application of cor.test ('stats' package).
  testKs <- cor.test(numericalSample1, numericalSample2, method = "spearman")

  pValue <- testKs$p.value

  testResult <- ifelse(pValue > 1 - testLevel, 1, 0)
  return(list(test = "TwoSampleSpearman",
              testResult = testResult,
              threshold = 1 - testLevel,
              pValue = pValue))
}

