/* $Id: context.h,v 1.16 2006-07-03 14:43:21 bh Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#ifndef CONTEXT_H
#  define CONTEXT_H

#ifdef USE_GTK
#include <gtk/gtk.h>
#endif

#ifndef USE_GTK
#include <glib.h>
#endif

typedef enum
{
  CONTEXT_GLOBAL = 0,
  CONTEXT_TASK,
  CONTEXT_SCOPE,
  CONTEXT_REPORT,
  CONTEXT_ENUM
} context_type;


typedef enum {
  CONTEXT_IDLE  = 0,
  CONTEXT_SCANNING
} context_action;


struct context {
  context_type type;
  context_action action;

  struct arglist *prefs;
  char * plugins_md5sum;
  struct nessus_plugin *plugins;
  struct nessus_plugin *scanners;
  struct arglist *dependencies;
  char *dir;
  int socket;
  const char *passwd;
  struct context *parent;
  struct context *children;
  struct context *next;
#ifdef ENABLE_SAVE_TESTS
  harglst * sessions;
  int sessions_saved;
  int detached_sessions_saved;
#endif
#ifdef USE_GTK
  GtkTreeRowReference *treerowref;
  GtkWidget *move_menuitem;
  GtkWidget *plugin_prefs_widget;
  GtkWidget *plugin_prefs_cred_widget;
  GtkWidget *pbar;
  GtkTreeStore *plugin_tree_store;
  GtkTreeModel *plugin_tree_model;
#endif
  /* reports may have plugin information too.  They can be quite large,
   * so we avoid loading them.  This flag indicates whether the plugin
   * information has been loaded.
   */
  int plugin_cache_loaded;
};

extern struct context *Global;
extern struct context *Context;

void context_init(struct context**, struct context*);
struct context *context_by_type(struct context*, context_type);
void context_reset_plugin_tree(struct context*);
void context_force_plugin_prefs_redraw(struct context *context);
void context_add_plugin(struct context*, struct nessus_plugin*);
void context_load_plugin_cache(struct context *context);
void context_set_plugins_md5sum(struct context *context, const char *md5sum);
void context_reset_plugins(struct context *context);

/* This function sync the plugin preferences (for plugins and scanners)
 * for the given context.
 * In fact, the plugin preferences are copied from
 * context->plugins[plugin][plugin-pref]
 * and
 * context->scanners->[plugin][plugin-pref]
 * to
 * context->prefs["PLUGINS_PREFS"][plugin]
 */
void context_sync_plugin_prefs(struct context *);

void context_collect(struct context*);
void context_rename(struct context*, const char*);
int context_move(struct context*, struct context*);
struct context *context_new(struct context*, const char*, const char*);
void context_delete(struct context*);
void context_save_recurse(struct context*);


int check_exists(const char *);
int check_is_file(const char *);
int check_is_dir(const char *);

#endif /* ifndef CONTEXT_H */

