/***********************************/ 
/* oroborus (c) Ken Lynch Jan 2001 */ 
/* Distributed under the GPL       */ 
/* See LICENSE for more details    */ 
/***********************************/ 
 
#include "oroborus.h" 
 
Display *dpy; 
Window root, check_win; 
Cursor resize_curs, move_curs; 
int screen; 
Client *client_list=NULL; 
long client_count; 
Config config; 
Atom icccm[ICCCM_ATOM_COUNT], motif[MOTIF_ATOM_COUNT], gnome[GNOME_ATOM_COUNT]; 
char *rcfile=RCFILE;

#ifdef SHAPE_SUPPORT 
int shape, shape_event; 
#endif 
 
#ifdef WORKSPACE_SUPPORT 
int workspace=0; 
#endif 
 
#ifdef XINERAMA_SUPPORT 
int xinerama; 
int xinerama_heads;
#ifndef EMULATE_XINERAMA
XineramaScreenInfo *xinerama_screens; 
#else
XineramaScreenInfo xinerama_screens[2]=
{
  {0, 0, 0, 512, 768},
  {0, 512, 84, 512, 600} 
};
#endif
#endif 

#ifdef I18N_SUPPORT
int use_fontset=False;
#endif
 
/*  
 * 
 * Quit nicely 
 * 
 */ 

void quit() 
{ 
#ifdef DEBUG 
  printf("quit\n"); 
#endif 
 
  /* Remove all frames */ 
  while(client_list)  
    delete_client(client_list, True); 
 
  /* Free cursors */ 
  XFreeCursor(dpy, resize_curs); 
  XFreeCursor(dpy, move_curs); 
 
  /* Free theme data */ 
  free_config(); 

  XSetInputFocus(dpy, root, RevertToPointerRoot, CurrentTime); 
  XCloseDisplay(dpy); 
  exit(0); 
} 
 
/* 
 * 
 * Handle signals 
 * 
 */ 

void signal_handler(int signal) 
{ 
#ifdef DEBUG 
  printf("signal_handler\n"); 
#endif 
 
  switch(signal) 
  { 
  case SIGINT: 
  case SIGTERM: 
    quit(); 
    break;
  case SIGHUP:
    reload_config();
    break;
  case SIGCHLD: 
    wait(NULL); 
    break; 
  } 
} 
 
/* 
 * 
 * Create a frame for each window that already exists 
 * 
 */ 

void scan_for_windows() 
{ 
  unsigned int count, i; 
  Window w1, w2, *windows=NULL; 
  XWindowAttributes attr; 
 
#ifdef DEBUG 
  printf("scan_for_windows\n"); 
#endif 
 
  XQueryTree(dpy, root, &w1, &w2, &windows, &count); 
  for(i=0; i<count; i++) 
  { 
    XGetWindowAttributes(dpy, windows[i], &attr); 
    if(!attr.override_redirect && attr.map_state==IsViewable) 
      create_new_client(windows[i], False); 
  } 
  if(windows) XFree(windows); 
} 
 
/* 
 * 
 * Initialize window manager 
 * 
 */ 

void init_wm() 
{ 
  int dummy; 
 
#ifdef DEBUG 
  printf("init_wm\n"); 
#endif 
 
  /* ICCCM stuff */ 
  icccm[WM_STATE]=XInternAtom(dpy, "WM_STATE", False); 
  icccm[WM_PROTOCOLS]=XInternAtom(dpy, "WM_PROTOCOLS", False); 
  icccm[WM_DELETE]=XInternAtom(dpy, "WM_DELETE_WINDOW", False); 
  icccm[WM_CHANGE_STATE]=XInternAtom(dpy, "WM_CHANGE_STATE", False); 
 
  /* Mwm hints */ 
  motif[MOTIF_WM_HINTS]=XInternAtom(dpy, "_MOTIF_WM_HINTS", False); 
 
  /* GNOME hints */ 
  gnome[WIN_CLIENT_LIST]=XInternAtom(dpy, "_WIN_CLIENT_LIST", False); 
  gnome[WIN_STATE]=XInternAtom(dpy, "_WIN_STATE", False); 
  gnome[WIN_HINTS]=XInternAtom(dpy, "_WIN_HINTS", False); 
  gnome[WIN_LAYER]=XInternAtom(dpy, "_WIN_LAYER", False); 
  gnome[WIN_SUPPORTING_WM_CHECK]=XInternAtom(dpy, "_WIN_SUPPORTING_WM_CHECK", False); 
  gnome[WIN_DESKTOP_BUTTON_PROXY]=XInternAtom(dpy, "_WIN_DESKTOP_BUTTON_PROXY", False); 
#ifdef WORKSPACE_SUPPORT 
  gnome[WIN_WORKSPACE]=XInternAtom(dpy, "_WIN_WORKSPACE", False); 
  gnome[WIN_WORKSPACE_COUNT]=XInternAtom(dpy, "_WIN_WORKSPACE_COUNT", False); 
#endif 
 
  /* Create GNOME check window */ 
  check_win=XCreateSimpleWindow(dpy, root, -200, -200, 5, 5, 0, 0, 0); 
   
  /* Set up GNOME properties */ 
  set_gnome_hint(check_win, WIN_SUPPORTING_WM_CHECK, check_win); 
  set_gnome_hint(root, WIN_SUPPORTING_WM_CHECK, check_win); 
  set_gnome_hint(check_win, WIN_DESKTOP_BUTTON_PROXY, check_win); 
  set_gnome_hint(root, WIN_DESKTOP_BUTTON_PROXY, check_win); 
#ifdef WORKSPACE_SUPPORT 
  set_gnome_hint(root, WIN_WORKSPACE_COUNT, config.workspace_count); 
  set_gnome_hint(root, WIN_WORKSPACE, 0); 
#endif 
  
#ifdef SHAPE_SUPPORT 
  /* Check for shape support */ 
  shape=XShapeQueryExtension(dpy, &shape_event, &dummy); 
#endif 
 
#ifdef XINERAMA_SUPPORT
#ifndef EMULATE_XINERAMA 
  /* Check xinerama extension */ 
  xinerama=XineramaQueryExtension(dpy, &dummy, &dummy); 
  if(xinerama) 
    xinerama_screens=XineramaQueryScreens(dpy, &xinerama_heads);
#else
  xinerama=True;
  xinerama_heads=2;
#endif
#endif 
 
  /* Set event mask for root window */ 
  XSelectInput(dpy, root, SubstructureRedirectMask|SubstructureNotifyMask|ButtonPressMask|ButtonReleaseMask|FocusChangeMask|PropertyChangeMask); 
 
  resize_curs=XCreateFontCursor(dpy, RESIZE_CURS); 
  move_curs=XCreateFontCursor(dpy, MOVE_CURS); 
} 
 
/* 
 * 
 * Set up signal handler 
 * 
 */ 

void init_signals() 
{ 
  struct sigaction act; 
 
#ifdef DEBUG 
  printf("init_signals\n"); 
#endif 
  
  act.sa_handler=signal_handler; 
  act.sa_flags=0; 
  sigaction(SIGTERM, &act, NULL); 
  sigaction(SIGINT, &act, NULL); 
  sigaction(SIGHUP, &act, NULL); 
  sigaction(SIGCHLD, &act, NULL); 
} 
 
/* 
 * 
 * Main routine 
 * 
 */ 

int main(int argc, char *argv[]) 
{
  char *dpy_str=NULL; 
  int i;
#ifdef I18N_SUPPORT 
  char *locale=NULL; 
#endif /* I18N */ 
 
#ifdef DEBUG 
  printf("main\n"); 
#endif 

  for(i=1;i<argc;i++)
  {
    if(!strcmp(argv[i], "-config") && i+1<argc)
      rcfile=argv[++i];
    else if(!strcmp(argv[i], "-display") && i+1<argc)
      dpy_str=argv[++i];
  }
 
#ifdef I18N_SUPPORT 
  locale=setlocale(LC_ALL, "");
  if(locale!=NULL)
  {
#ifdef DEBUG
    printf("locale=%s\n", locale);
#endif
    if(strcmp(locale, "C") && strcmp(locale, "POSIX") && XSupportsLocale())
      use_fontset=True;
  }
#ifdef DEBUG
  if(use_fontset)
    printf("setting use_fontset=True\n");
  else
    printf("setting use_fontset=False\n");
#endif
#endif /* I18N */ 
 
  /* Initialize X */ 
  if(!(dpy=XOpenDisplay(dpy_str)))
  { 
    fprintf(stderr, "%s: Can't open display, X may not be running.", PROGNAME);
    exit(1);
  }
 
  root=XDefaultRootWindow(dpy); 
  screen=XDefaultScreen(dpy); 
 
  XSetErrorHandler(handle_xerror); 
   
  init_signals(); 
  load_config(); 
  init_wm();
#ifdef KEYBOARD_SUPPORT
  init_keyboard();
#endif 
  scan_for_windows(); 
  do_event_loop(); 
  return 1; 
} 
