/***********************************/ 
/* oroborus (c) Ken Lynch Jan 2001 */ 
/* Distributed under the GPL       */ 
/* See LICENSE for more details    */ 
/***********************************/ 
 
#ifndef OROBORUS_H 
#define OROBORUS_H 
 
#include <X11/Xlib.h> 
#include <X11/Xutil.h> 
#include <X11/Xatom.h> 
#include <X11/Xmd.h> 
#include <X11/xpm.h> 
#include <X11/cursorfont.h> 
 
#ifdef I18N_SUPPORT 
# include <X11/Xlocale.h> 
#endif /* I18N */ 
 
#ifdef SHAPE_SUPPORT 
#include <X11/extensions/shape.h> 
#endif /* SHAPE */ 
 
#ifdef XINERAMA_SUPPORT
#ifndef EMULATE_XINERAMA 
#include <X11/extensions/Xinerama.h> 
#endif
#endif /* XINERAMA */  
 
#include <stdlib.h> 
#include <stdio.h> 
#include <string.h> 
#include <sys/wait.h> 
#include <sys/stat.h> 
#include <time.h>
#include <signal.h> 
#include <unistd.h> 
 
/* 
 * 
 * Various defines 
 * 
 */ 

#define PROGNAME		"OROBORUS"
#define RESIZE_CURS		XC_sizing 
#define MOVE_CURS		XC_fleur 
#define DBL_CLICK		250 
#define TAB_RAISE_TIMEOUT	1000 
 
/* 
 * 
 * Various flags 
 * 
 */ 
 
/* Gravitate modes */ 
#define APPLY_GRAVITY		1 
#define REMOVE_GRAVITY		-1 
 
/* Window areas */ 
#define FRAME			0 
#define WINDOW			1 
#define TITLE			2 
 
/* Window placement */ 
#define CENTER_MOUSE		0 
#define CENTER_ROOT		1 
 
/* Focus styles */ 
#define FOCUS_CLICK		0 
#define FOCUS_SLOPPY		1 
 
/* Frame states */ 
#define FRAME_ACTIVE		0 
#define FRAME_INACTIVE		1
#define FRAME_ACTIVE_SHADED	2
#define FRAME_INACTIVE_SHADED	3
 
/* Button states */ 
#define BUTTON_UNPRESSED	0 
#define BUTTON_PRESSED		2 
 
/* Text alignments */ 
#define ALIGNMENT_LEFT		0 
#define ALIGNMENT_MIDDLE	1 
#define ALIGNMENT_RIGHT		2 
 
/* 
 * 
 * Simplify some long calculations 
 * 
 */ 
 
/* Gravity */ 
#define GRAVITY		(c->size->flags&PWinGravity?c->size->win_gravity:NorthWestGravity) 
 
/* Title size and position */ 
#define TH	(c->has_frame?config.title.height:0) 
#define TW	(c->has_frame?(FW-config.top_right.width-config.top_left.width):0) 
#define TX	(config.top_left.width) 
#define TY	0 
 
/* Frame size and position */ 
#define FW	(c->width+LW+RW) 
#define FH	((get_gnome_hint(c->window, WIN_STATE)&WIN_STATE_SHADED?-BH:c->height)+TH+BH) 
#define FX	(c->x-LW) 
#define FY	(c->y-TH) 
 
/* Top left border size and position */ 
#define TLW	(config.top_left.width) 
#define TLH	(config.top_left.height) 
#define TLX	0 
#define TLY	0 
 
/* Top right border size and position */ 
#define TRW	(config.top_right.width) 
#define TRH	(config.top_right.height) 
#define TRX	(FW-config.top_right.width) 
#define TRY	0 
 
/* Left border size and position */ 
#define LW	(c->has_frame?config.left.width:0) 
#define LH	(c->height) 
#define LX	0 
#define LY	(TH) 
 
/* Right border size and position */ 
#define RW	(c->has_frame?config.right.width:0) 
#define RH	(c->height) 
#define RX	(c->width+LW) 
#define RY	(TH) 
 
/* Bottom left border size and position */ 
#define BLW	(config.bottom_left.width) 
#define BLH	(config.bottom_left.height) 
#define BLY	(FH-config.bottom_left.height) 
#define BLX	0 
 
/* Bottom border size and position */ 
#define BH	(c->has_frame?config.bottom.height:0) 
#define BW	(c->width) 
#define BX	(LW) 
#define BY	(FH-BH) 
 
/* Resize size and position */ 
#define RSX	(FW-config.resize.width) 
#define RSY	(FH-config.resize.height) 
#define RSH	(config.resize.height) 
#define RSW	(config.resize.width) 
 
/* Close button size and position */ 
#define CX	(LW+c->width-config.close.width+1) 
#define CY	((TH-config.close.height)/2) 
#define CW	(config.close.width) 
#define CH	(config.close.height) 
 
/* Hide button size and position */ 
#define HX	(LW-1) 
#define HY	((TH-config.hide.height)/2) 
#define HW	(config.hide.width) 
#define HH	(config.hide.height) 
 
/* 
 * 
 * Atoms and hints 
 * 
 */ 
 
/* ICCCM atoms */ 
#define WM_STATE			0 
#define WM_CHANGE_STATE			1 
#define WM_DELETE			2 
#define WM_PROTOCOLS			3 
#define ICCCM_ATOM_COUNT		4 
 
/* Motif atoms */ 
#define MOTIF_WM_HINTS			0 
#define MOTIF_ATOM_COUNT		1 
 
/* GNOME atoms */ 
#define WIN_STATE			0 
#define WIN_LAYER			1 
#define WIN_CLIENT_LIST			2 
#define WIN_DESKTOP_BUTTON_PROXY	3 
#define WIN_HINTS			4 
#define WIN_SUPPORTING_WM_CHECK		5 
#define WIN_WORKSPACE			6 
#define WIN_WORKSPACE_COUNT		7 
#define GNOME_ATOM_COUNT		8 
 
/* Mwm hints */ 
#define MWM_HINTS_DECORATIONS		(1L<<1) 
#define MWM_DECOR_ALL			(1L<<0) 
#define MWM_DECOR_BORDER		(1L<<1) 
#define MWM_DECOR_TITLE			(1L<<3) 
#define MWM_DECOR_MAXIMIZE		(1L<<6) 
 
/* GNOME hints */ 
#define WIN_HINTS_SKIP_FOCUS		(1<<0) 
#define WIN_HINTS_SKIP_TASKBAR		(1<<2) 
#define WIN_STATE_STICKY		(1<<0) 
#define WIN_STATE_MAXIMIZED_VERT	(1<<2) 
#define WIN_STATE_MAXIMIZED_HORIZ	(1<<3) 
#define WIN_STATE_MAXIMIZED		(WIN_STATE_MAXIMIZED_VERT|WIN_STATE_MAXIMIZED_HORIZ) 
#define WIN_STATE_SHADED		(1<<5) 
#define WIN_LAYER_DESKTOP		0 
#define WIN_LAYER_BELOW			2 
#define WIN_LAYER_NORMAL		4 
#define WIN_LAYER_ONTOP			6 
 
/* 
 * 
 * Structures 
 * 
 */ 
 
/* Mwm hints structure */ 
typedef struct 
{ 
  CARD32 flags; 
  CARD32 functions; 
  CARD32 decorations; 
  INT32 inputMode; 
  CARD32 status; 
} PropMwmHints; 
 
/* Client structure */ 
typedef struct _Client Client; 
 
struct _Client 
{ 
  Window window, frame, trans, title, top_left, top_right, left, right, bottom_left, bottom, resize, hide, close; 
  char *name; 
  XSizeHints *size; 
  int x, y, width, height, old_x, old_y, old_width, old_height, has_frame, ignore_unmap, hide_state, close_state, can_max, has_focus; 
  Client *next; 
  Client *prev; 
}; 
 
/* Frame part structure */ 
typedef struct 
{ 
  Pixmap pixmap[4], mask[2]; 
  int width, height; 
} FramePart; 
 
#ifdef KEYBOARD_SUPPORT 
/* Key structure */ 
typedef struct 
{ 
  int keycode; 
  int modifier; 
} Key; 
 
/* Keys structure */ 
typedef struct 
{ 
  Key next_window, prev_window, maximize, shade, hide, close, move_up, move_down, move_left, move_right, resize_up, resize_down, resize_left, resize_right; 
 
#ifdef LAYER_SUPPORT 
  Key raise_layer, lower_layer; 
#endif /* LAYER */ 
 
#ifdef WORKSPACE_SUPPORT 
  Key sticky, add_ws, del_ws; 
  Key next_ws, prev_ws, ws_1, ws_2, ws_3, ws_4, ws_5, ws_6, ws_7, ws_8, ws_9; 
  Key move_next_ws, move_prev_ws, move_ws_1, move_ws_2, move_ws_3, move_ws_4, move_ws_5, move_ws_6, move_ws_7, move_ws_8, move_ws_9; 
#endif /* WORKSPACE */ 
} Keys; 
#endif /* KEYBOARD */ 
 
/* Config structure */ 
typedef struct 
{ 
  char *theme_dir;
  FramePart resize, hide, close, top_left, title, top_right, left, right, bottom_left, bottom; 
  int text_align; 
  GC font_gc[2]; 
  XFontStruct *font; 
 
#ifdef I18N_SUPPORT 
  XFontSet fontset; 
#endif /* I18N */ 
 
  int window_placement, focus_style, raise_on_focus, focus_new, continuous_resize; 
  int top_margin, bottom_margin, left_margin, right_margin; 
 
#ifdef KEYBOARD_SUPPORT 
  Keys keys;
#endif /* KEYBOARD */ 
 
#ifdef WORKSPACE_SUPPORT 
  int workspace_count; 
#endif /* WORKSPACE */ 
} Config; 

#ifdef EMULATE_XINERAMA
  typedef struct
  {
    int screen;
    short x_org;
    short y_org;
    short width;
    short height;
  } XineramaScreenInfo;
#endif 
 
/* 
 * 
 * Global variables 
 * 
 */ 
 
/* oroborus.c */ 
extern Display *dpy; 
extern Window root, check_win; 
extern Cursor move_curs, resize_curs; 
extern int screen; 
extern Client *client_list; 
extern Config config; 
extern long client_count; 
extern Atom icccm[ICCCM_ATOM_COUNT], motif[MOTIF_ATOM_COUNT], gnome[GNOME_ATOM_COUNT]; 
extern char *rcfile;

#ifdef SHAPE_SUPPORT 
extern int shape, shape_event; 
#endif /* SHAPE */ 
 
#ifdef WORKSPACE_SUPPORT 
extern int workspace; 
#endif /* WORKSPACE */ 
 
#ifdef XINERAMA_SUPPORT 
extern int xinerama; 
extern int xinerama_heads;
#ifndef EMULATE_XINERAMA
extern XineramaScreenInfo *xinerama_screens;
#else
extern XineramaScreenInfo xinerama_screens[2]; 
#endif
#endif /* XINERAMA */ 

#ifdef I18N_SUPPORT
extern int use_fontset;
#endif /* I18N_SUPPORT */
 
/* 
 * 
 * Functions 
 * 
 */ 
 
/* client.c */
extern void gravitate_client(Client *, int); 
extern void create_new_client(Window, int); 
extern Client *get_client_from_window(Window, int); 
extern Client *get_focus_client(); 
extern Client *get_next_client(Client *);
extern Client *get_prev_client(Client *);
extern Client *get_top_most_client(int); 
extern Client *get_bottom_most_client(int); 
extern void raise_client(Client *); 
extern void set_focus_client(Client *); 
extern void lower_client(Client *); 
extern void show_client(Client *); 
extern void hide_client(Client *); 
extern void configure_client(Client *, unsigned int, XWindowChanges *, int); 
extern void move_client(Client *, int, int); 
extern void resize_client(Client *, int, int, int); 
extern void toggle_client_maximized(Client *); 
extern void toggle_client_shaded(Client *); 
extern void set_client_layer(Client *, int); 
extern int get_client_layer(Client *); 
extern void delete_client(Client *, int); 
extern void close_client(Client *); 
extern void redraw_client_frame(Client *); 
extern void redraw_client_buttons(Client *); 
extern void redraw_client_title(Client *); 
 
#ifdef SHAPE_SUPPORT 
extern void set_client_shape(Client *); 
#endif /* SHAPE */ 
 
#ifdef WORKSPACE_SUPPORT 
extern void toggle_client_sticky(Client *); 
extern void move_client_to_workspace(Client *, int); 
#endif /* WORKSPACE */ 
 
/* hints.c */ 
extern PropMwmHints *get_mwm_hints(Window); 
extern void set_wm_state(Window, int); 
extern long get_wm_state(Window); 
extern void set_gnome_hint(Window, int, long); 
extern long get_gnome_hint(Window, int); 
extern void update_gnome_client_list(); 
 
/* event.c */ 
extern void do_event_loop(); 
 
/* config.c */ 
extern void load_config(); 
extern void free_config(); 
extern void reload_config(); 
extern time_t config_modified(char *, char *); 
 
/* misc.c */ 
extern int handle_xerror(Display *, XErrorEvent *); 
extern void add_dir_to_font_path(char *);
extern void rem_dir_from_font_path(char *);
extern void get_mouse_xy(int *, int *); 
extern Window get_pointer_win(Window); 
extern Window get_window_parent(Window); 
extern int screen_width(int); 
extern int screen_height(int); 
extern int screen_x(int); 
extern int screen_y(int); 
 
#ifdef XINERAMA_SUPPORT 
extern int find_head(int, int); 
#endif /* XINERAMA */ 
 
#ifdef I18N_SUPPORT 
extern Status XGetWMNameWrapper(Display *, Window, XTextProperty *); 
extern Status XFetchNameWrapper(Display *, Window, char **); 
extern XFontSet XLoadQueryFontWrapper(Display *, const char *); 
#endif /* I18N */ 
 
/* pixmaps.c */ 
extern void load_pixmaps(char *, XpmColorSymbol *, int); 
 
#ifdef KEYBOARD_SUPPORT 
/* keyboard.c */
extern void init_keyboard(); 
extern void parse_key(char *, Key *); 
extern void ungrab_keys(Window); 
extern void grab_keys(Window); 
#endif /* KEYBOARD */ 
 
#ifdef WORKSPACE_SUPPORT 
/* workspace.c */ 
extern void change_to_workspace(int); 
extern void update_workspace_count(); 
#endif /* WORKSPACE */ 
 
#endif /* OROBORUS_H */ 

