/*
 *
 * Copyright (C) 2005, 2006 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */
#ifndef OSGCAL_H
#define OSGCAL_H

#include <vector>
#include <string>
#include <osg/Vec3>
#include <osgText/Text>
#include "osgviewer.h"

struct osgViewer;

namespace osgCal {
  class Model;
};

struct ParseArguments
{
  int mNumloops;
  int mNumframes;
  int mFixcam_flag;
  int mVerbose_flag;
  int mVertexprogram_flag;
  int mBenchmark_flag;
  int mNumframes_flag;
  int mDirectory_flag;
  std::vector<std::string> mPositional_arguments;
  int mFile;
  int mArgc;
  int mError_occurred;
  char** mArgv;
  std::string mPath;
  std::string mSuffix;
  std::string mDirectory;

  ParseArguments(int ac, char** av);
  bool Parse();

};


class Manipulator  
{

 public:

  Manipulator(osgViewer& viewer, osgCal::Model *model, bool fixcam, bool vertexProgram);
  void InitCamera();
  void RecomputeCamera();
  void Update();

  /** handle events, return true if handled, false otherwise.*/
  void Handle(EventList& events);

  typedef std::vector<std::string> Outfits;

  void setOutfits(const Outfits& outfits);
  int getNbOutfit();
  void applyNextOutfit();
  void SetComment(osgText::Text* comment);
  void launchAnim();

 protected:

  bool mFixcam_flag;
  Outfits mOutfits;
  int mCurrentOutfit;
  float mStep;
  osg::Vec3 mTarget, mPosition;
  bool mLeftButton, mRightButton;
	bool mVertexProgram;
  osg::Vec3 mCameraRotation;
  osg::ref_ptr<osgText::Text> mComment;
  int mMouseX,mMouseY;
	osg::ref_ptr<osgCal::Model> mModel;
  int mNMov;
  osgViewer& mViewer;
};

std::string read_file(const std::string& path);

#endif
