
/*****************************************************************************
**
**  Copyright (C) 2002  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/*****************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      fileapi.h
**    Author:    Brian Wotring
**
**    Date:      May 14, 2002
**    Project:   osiris
**
******************************************************************************/

#ifndef FILEAPI_H
#define FILEAPI_H


/* error codes and their translation to string messages. */

#ifdef __cplusplus
extern "C"
{
#endif

#ifndef WIN32
extern int errno;
#endif

typedef struct OSI_DIRECTORY
{
    char path[MAX_PATH_LENGTH];
    char filename[MAX_PATH_LENGTH];

#ifdef WIN32

    HANDLE handle;
    WIN32_FIND_DATA file;

#else

    DIR *handle;
    struct dirent *file;

#endif

    /* used in case we need to traverse with getdirentries. */
    /* instead of opendir and readdir.                      */

    unsigned long dd_loc;
    unsigned long dd_seek;
    unsigned long dd_fd;
    unsigned long dd_size;
    unsigned long dd_len;

    unsigned char buffer[8192];

} OSI_DIRECTORY;

int fileapi_get_last_error();

osi_bool osi_open_directory( const char *filepath, OSI_DIRECTORY *directory );
osi_bool osi_close_directory( OSI_DIRECTORY *directory );

#ifndef WIN32
osi_bool osi_directory_set_fd( OSI_DIRECTORY *directory, int fd );
#endif

osi_bool osi_get_next_file( OSI_DIRECTORY *directory );

int osi_create_directory( const char *filepath );
int osi_remove_directory( const char *filepath );
int osi_create_subdirectory( const char *rootpath, const char *directory );
int osi_create_file( const char *filepath, mode_t mode );
int osi_remove_file( const char *filepath );
int osi_remove_files_from_directory( const char *filepath );

int osi_get_file_from_path( const char *filepath, char *filename, int size );

osi_bool osi_file_exists( const char *filepath );
osi_bool osi_directory_exists( const char *filepath );
osi_bool osi_subdirectory_exists( const char *rootpath, const char *directory );
osi_bool osi_file_is_regular_file( const char *filepath );
osi_bool osi_file_is_directory( const char *filepath, struct stat *file_stats );

osi_bool osi_get_user_home_directory( char *buffer, int buffer_size );
osi_bool osi_get_osiris_home_directory( char *buffer, int buffer_size );
osi_bool osi_osiris_home_directory_exists();
osi_bool osi_get_osirismd_home_directory( char *buffer, int buffer_size );
osi_bool osi_osirismd_home_directory_exists();

#ifndef WIN32
struct dirent * osi_readdir( OSI_DIRECTORY *d );
#endif

#ifdef WIN32
osi_bool osi_get_windows_directory( char *buffer, int buffer_size );
#endif


#ifdef __cplusplus
}
#endif

#endif
