///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOMVIZ_ATOM_INFO_UTILITY_H
#define __ATOMVIZ_ATOM_INFO_UTILITY_H

#include <core/Core.h>
#include <core/plugins/utility/UtilityPlugin.h>
#include <core/viewport/input/ViewportInputHandler.h>
#include <core/viewport/input/ViewportInputManager.h>

#include <atomviz/AtomViz.h>
#include <atomviz/atoms/AtomsObject.h>
#include "AtomPicker.h"

namespace AtomViz {

class ATOMVIZ_DLLEXPORT AtomInformationInputMode : public ViewportInputHandler, private AtomPicker
{
public:

	/// Constructor.
	AtomInformationInputMode(QLabel* _resultLabel) :
		resultLabel(_resultLabel) {}

	/// Returns the activation behaviour of this input handler.
	virtual InputHandlerType handlerActivationType() {
		return ViewportInputHandler::NORMAL;
	}

	/// Handles the mouse down events for a Viewport.
	virtual void onMouseDown(Viewport& vp, QMouseEvent* event);

	/// \brief Lets the input mode render its overlay content in a viewport.
	virtual void renderOverlay(Viewport* vp, bool isActive);

	/// \brief Indicates whether this input mode renders into the viewports.
	virtual bool hasOverlay() { return true; }

private:

	/// The label that displays the properties of the selected atom.
	QLabel* resultLabel;

	/// The atom for which the properties are being displayed.
	PickAtomResult pickedAtom;
};

/**
 * \brief This utility applet lets the user select an atom in the viewports to display its properties.
 *
 * \author Alexander Stukowski
 */
class ATOMVIZ_DLLEXPORT AtomInformationUtility : public UtilityPlugin
{
public:
	/// Default constructor.
	AtomInformationUtility();

	/// Shows the UI of the utility in the given RolloutContainer.
	virtual void openUtility(RolloutContainer* container, const RolloutInsertionParameters& rolloutParams = RolloutInsertionParameters());

	/// Removes the UI of the utility from the rollout container.
	virtual void closeUtility(RolloutContainer* container);

private:

	/// The applet panel.
	QWidget* panel;
	/// The viewport input mode.
	AtomInformationInputMode::SmartPtr inputMode;

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(AtomInformationUtility)
};

};

#endif // __ATOMVIZ_ATOM_INFO_UTILITY_H
