'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS1977 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS1977
\- Password Protected 32kbit Memory iButton
.SH SYNOPSIS
Non-volatile memory.
.PP
.B 37
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-510|ALL]
|
.B set_number/full
|
.B set_number/read
|
.B set_password/enabled
|
.B set_password/full
|
.B set_password/read
|
.B use_number/full
|
.B use_number/read
|
.B use_password/full
|
.B use_password/read
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 37
DS1977
.SH SPECIAL PROPERTIES
.SS memory
.I read-write, binary
.br
32704 bytes of memory. Possibly protected by a password.
.SS pages/page.0 ... pages/page.510 pages/page.ALL
.I read-write, binary
.br
Memory is split into 511 pages of 64 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SS set_number/full set_number/read
.I write-only, ascii
.br
Passwords entered as numbers, either decimal, or hex of form 0x0123456789ABCDEF. Handled the same as
.I set_password/xxx
.SS set_password/enable
.I read-write, yes-no
.br
Turn on/off password protection for the DS1977, or return the current state.
.SS set_password/full set_password/read
.I write-only, binary
.br
Passwords (8 byte values) that allow read or full access to the DS1977 memory. The password set by
.I set_password/xxx
are stored in the DS1977 and locally in the program as well (as if
.I use_password/xxx
was also called).
.SS use_password/full use_password/read
.I write-only, binary
.br
Passwords (8 byte values) that allow read or full access to the DS1977 memory. The password set by
.SS use_number/full use_number/read
.I write-only, ascii
.br
Passwords entered as numbers, either decimal, or hex of form 0x0123456789ABCDEF. Handled the same as
.I use_password/xxx
.SS use_password/full use_password/read
.I write-only, binary
.br
Passwords (8 byte values) that allow read or full access to the DS1977 memory. The password set by
.I use_password/xxx
are stored in the program and must match the passwords stored in the DS1977. Changing the DS1977 passwords using
.I set_password/xxx
will change these values as well.
.I use_password/xxx
are stored in the program and must match the passwords stored in the DS1977. Changing the DS1977 passwords using
.I set_password/xxx
will change these values as well.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1977
The
.B DS1977 (3)
is an iButton with static memory that is optionally protected by a password.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS1977.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
