/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson   *
 *   nq@altern.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "buttonwithindexsignal.h"

ButtonWithIndexSignal::ButtonWithIndexSignal(const QString & text, int index, QWidget *parent, const char *name) : QPushButton(text, parent, name) {
	i = index;
	connect(this, SIGNAL(clicked()), this, SLOT(emitClickedWithIndex()));
}
ButtonWithIndexSignal::~ButtonWithIndexSignal() {}
void ButtonWithIndexSignal::emitClickedWithIndex() {
	emit clickedWithIndex(i);
}

#include "buttonwithindexsignal.moc"
