/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: calccategory.cpp 333 2005-11-03 00:36:01Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "calccategory.h"
#include "kbanking.h"
#include "category.h"

#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qprogressdialog.h>
#include <qapplication.h>
#include <qpushbutton.h>

#include <gwenhywfar/debug.h>




CalculateCategory::CalculateCategory(KBanking *kb,
                                     Category *p,
                                     AB_VALUE *value,
                                     QWidget* parent,
                                     const char* name,
                                     WFlags fl)
:CheckDuplicatesUI(0, name, fl)
,_app(kb)
,_aborted(false)
,_category(p)
,_value(value) {
  QObject::connect(abortButton, SIGNAL(clicked()),
                   this, SLOT(slotAbortClicked()));

  accountsProgress->setTotalSteps(-1);
  accountsProgress->setProgress(-1);
  transactionsProgress->setTotalSteps(-1);
  transactionsProgress->setProgress(-1);
}



CalculateCategory::~CalculateCategory(){
}



bool CalculateCategory::calculate() {
  std::list<Account*>::const_iterator it;
  int accnt;

  setCaption(tr("Calculating for category"));

  accountsProgress->setTotalSteps(_app->getAppAccounts().size());
  accountsProgress->setProgress(0);
  accnt=0;
  for (it=_app->getAppAccounts().begin();
       it!=_app->getAppAccounts().end();
       it++) {
    AH_STORAGE *st;
    int year, month, day;
    int rv;
    GWEN_IDLIST *idl;

    DBG_DEBUG(0, "Handling account %s / %s",
              (*it)->getBankCode().c_str(),
              (*it)->getAccountNumber().c_str());

    st=(*it)->getStorage();
    assert(st);

    idl=AH_Storage_GetAvailableDays(st);
    assert(idl);
    rv=AH_Storage_GetFirstDay(st, idl, &year, &month, &day);
    if (!rv) {
      GWEN_TIME *ct;
      GWEN_TIME *ft;
      int totalDays;

      ct=GWEN_CurrentTime();
      assert(ct);
      ft=GWEN_Time_new(year, month-1, day, 0, 0, 0, 1);
      assert(ft);

      totalDays=(int)((GWEN_Time_Seconds(ct)-GWEN_Time_Seconds(ft))/
                      (60*60*24));
      transactionsProgress->setTotalSteps(totalDays);
      transactionsProgress->setProgress(0);
      GWEN_Time_free(ct);

      while(!rv) {
        GWEN_TYPE_UINT32 id = 0;
        GWEN_DB_NODE *db;
        GWEN_TIME *ti;

        ti=0;
        DBG_DEBUG(0, "Loading day %04d/%02d/%02d", year, month, day);
  
        qApp->processEvents();
        if (_aborted) {
          DBG_ERROR(0, "User aborted");
          if (id)
            AH_Storage_AbandonDay(st, id);
          GWEN_IdList_free(idl);
          return false;
        }
  
        id=AH_Storage_OpenDay(st, year, month, day, 1);
        if (!id) {
          DBG_ERROR(0, "Error loading day %04d/%02d/%02d",
                    year, month, day);
          GWEN_IdList_free(idl);
          return false;
        }
    
        db=AH_Storage_GetFirstTransaction(st, id);
        if (!db) {
          DBG_WARN(0, "No transactions in day %04d/%02d/%02d",
                   year, month, day);
        }
        while(db) {
          const char *pid;

          DBG_DEBUG(0, "Got a transaction");
          pid=GWEN_DB_GetCharValue(db, "category", 0, 0);
          if (pid) {
            if (strcasecmp(_category->getId().c_str(), pid)==0) {
              GWEN_DB_NODE *dbValue;

              dbValue=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                                       "value");
              if (dbValue) {
                AB_VALUE *v;

                v=AB_Value_fromDb(dbValue);
                if (v) {
                  AB_Value_AddValue(_value, v);
                  AB_Value_free(v);
                }
              }
            }
          }
          db=AH_Storage_GetNextTransaction(st, id);
        } // for transaction

        if (AH_Storage_CloseDay(st, id)) {
          DBG_ERROR(0, "Error closing day %04d/%02d/%02d",
                    year, month, day);
          GWEN_IdList_free(idl);
          return false;
        }

        ti=GWEN_Time_new(year, month-1, day, 0, 0, 0, 1);
        transactionsProgress->setProgress((int)((GWEN_Time_Seconds(ti)-
                                                 GWEN_Time_Seconds(ft)
                                                )/
                                                (60*60*24)));
        GWEN_Time_free(ti);

        rv=AH_Storage_GetNextDay(st, idl, &year, &month, &day);
      } /* while !rv */
      GWEN_Time_free(ft);
    } /* if first day */
    GWEN_IdList_free(idl);

    accnt++;
    accountsProgress->setProgress(accnt);
  } // for account

  accountsProgress->setTotalSteps(1);
  accountsProgress->setProgress(1);
  transactionsProgress->setTotalSteps(1);
  transactionsProgress->setProgress(1);

  return true;
}



bool CalculateCategory::calculateAll() {
  std::list<Account*>::const_iterator it;
  std::list<Category*>::const_iterator pit;
  int accnt;

  setCaption(tr("Calculating for categorys"));
  accountsProgress->setTotalSteps(_app->getAppAccounts().size());
  accountsProgress->setProgress(0);
  accnt=0;

  // reset all categorys' values
  for (pit=_app->getCategories().begin();
       pit!=_app->getCategories().end();
       pit++)
    (*pit)->resetValues();

  // calculate new ones
  for (it=_app->getAppAccounts().begin();
       it!=_app->getAppAccounts().end();
       it++) {
    AH_STORAGE *st;
    int year, month, day;
    int rv;
    GWEN_IDLIST *idl;

    DBG_DEBUG(0, "Handling account %s / %s",
              (*it)->getBankCode().c_str(),
              (*it)->getAccountNumber().c_str());

    st=(*it)->getStorage();
    assert(st);

    idl=AH_Storage_GetAvailableDays(st);
    assert(idl);
    rv=AH_Storage_GetFirstDay(st, idl, &year, &month, &day);
    if (!rv) {
      GWEN_TIME *ct;
      GWEN_TIME *ft;
      int totalDays;

      ct=GWEN_CurrentTime();
      assert(ct);
      ft=GWEN_Time_new(year, month-1, day, 0, 0, 0, 1);
      assert(ft);

      totalDays=(int)((GWEN_Time_Seconds(ct)-GWEN_Time_Seconds(ft))/
                      (60*60*24));
      transactionsProgress->setTotalSteps(totalDays);
      transactionsProgress->setProgress(0);
      GWEN_Time_free(ct);

      while(!rv) {
        GWEN_TYPE_UINT32 id = 0;
        GWEN_DB_NODE *db;
        std::list<RefPointer<Transaction> > tl;
        std::list<RefPointer<Transaction> >::iterator xait;
        GWEN_TIME *ti;

        ti=0;
        DBG_DEBUG(0, "Loading day %04d/%02d/%02d", year, month, day);
  
        qApp->processEvents();
        if (_aborted) {
          DBG_ERROR(0, "User aborted");
          if (id)
            AH_Storage_AbandonDay(st, id);
          GWEN_IdList_free(idl);
          return false;
        }
  
        id=AH_Storage_OpenDay(st, year, month, day, 1);
        if (!id) {
          DBG_ERROR(0, "Error loading day %04d/%02d/%02d",
                    year, month, day);
          GWEN_IdList_free(idl);
          return false;
        }
    
        db=AH_Storage_GetFirstTransaction(st, id);
        if (!db) {
          DBG_WARN(0, "No transactions in day %04d/%02d/%02d",
                   year, month, day);
        }
        while(db) {
          const char *pid;

          DBG_DEBUG(0, "Got a transaction");
          pid=GWEN_DB_GetCharValue(db, "category", 0, 0);
          if (pid && *pid) {
            Category *category;

            category=_app->findCategoryById(pid);
            if (category) {
              GWEN_DB_NODE *dbValue;

              dbValue=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                                       "value");
              if (dbValue) {
                AB_VALUE *v;

                v=AB_Value_fromDb(dbValue);
                if (v) {
                  category->addValue(v);
                  AB_Value_free(v);
                }
              }
            }
          }
          db=AH_Storage_GetNextTransaction(st, id);
        } // for transaction

        if (AH_Storage_CloseDay(st, id)) {
          DBG_ERROR(0, "Error closing day %04d/%02d/%02d",
                    year, month, day);
          _app->flagStaff()->categoriesUpdated();
          GWEN_IdList_free(idl);
          return false;
        }

        ti=GWEN_Time_new(year, month-1, day, 0, 0, 0, 1);
        transactionsProgress->setProgress((int)((GWEN_Time_Seconds(ti)-
                                                 GWEN_Time_Seconds(ft)
                                                )/
                                                (60*60*24)));
        GWEN_Time_free(ti);

        rv=AH_Storage_GetNextDay(st, idl, &year, &month, &day);
      } /* while !rv */
      GWEN_Time_free(ft);
    } /* if first day */
    GWEN_IdList_free(idl);

    accnt++;
    accountsProgress->setProgress(accnt);
  } // for account

  accountsProgress->setTotalSteps(1);
  accountsProgress->setProgress(1);
  transactionsProgress->setTotalSteps(1);
  transactionsProgress->setProgress(1);

  _app->flagStaff()->categoriesUpdated();
  return true;
}



void CalculateCategory::slotAbortClicked(){
  _aborted=true;
  abortButton->setEnabled(false);
}



bool CalculateCategory::_isOfCategory(const char *s, Category *cat) {
  std::list<Category*>::iterator it;

  if (strcasecmp(cat->getId().c_str(), s)==0)
    return true;
  for (it=cat->getChildren().begin();
       it!=cat->getChildren().end();
       it++) {
    if (_isOfCategory(s, *it))
      return true;
  }

  return false;
}



bool CalculateCategory::getTransactions(std::list<RefPointer<Transaction> > &l) {
  std::list<Account*>::const_iterator it;
  int accnt;

  setCaption(tr("Getting transactions for category"));

  accountsProgress->setTotalSteps(_app->getAppAccounts().size());
  accountsProgress->setProgress(0);
  accnt=0;
  for (it=_app->getAppAccounts().begin();
       it!=_app->getAppAccounts().end();
       it++) {
    AH_STORAGE *st;
    int year, month, day;
    int rv;
    GWEN_IDLIST *idl;

    DBG_DEBUG(0, "Handling account %s / %s",
              (*it)->getBankCode().c_str(),
              (*it)->getAccountNumber().c_str());

    st=(*it)->getStorage();
    assert(st);

    idl=AH_Storage_GetAvailableDays(st);
    assert(idl);
    rv=AH_Storage_GetFirstDay(st, idl, &year, &month, &day);
    if (!rv) {
      GWEN_TIME *ct;
      GWEN_TIME *ft;
      int totalDays;

      ct=GWEN_CurrentTime();
      assert(ct);
      ft=GWEN_Time_new(year, month-1, day, 0, 0, 0, 1);
      assert(ft);

      totalDays=(int)((GWEN_Time_Seconds(ct)-GWEN_Time_Seconds(ft))/
                      (60*60*24));
      transactionsProgress->setTotalSteps(totalDays);
      transactionsProgress->setProgress(0);
      GWEN_Time_free(ct);

      while(!rv) {
        GWEN_TYPE_UINT32 id = 0;
        GWEN_DB_NODE *db;
        GWEN_TIME *ti;

        ti=0;
        DBG_DEBUG(0, "Loading day %04d/%02d/%02d", year, month, day);
  
        qApp->processEvents();
        if (_aborted) {
          DBG_ERROR(0, "User aborted");
          if (id)
            AH_Storage_AbandonDay(st, id);
          GWEN_IdList_free(idl);
          return false;
        }
  
        id=AH_Storage_OpenDay(st, year, month, day, 1);
        if (!id) {
          DBG_ERROR(0, "Error loading day %04d/%02d/%02d",
                    year, month, day);
          GWEN_IdList_free(idl);
          return false;
        }
    
        db=AH_Storage_GetFirstTransaction(st, id);
        if (!db) {
          DBG_WARN(0, "No transactions in day %04d/%02d/%02d",
                   year, month, day);
        }
        while(db) {
          const char *pid;

          DBG_DEBUG(0, "Got a transaction");
          pid=GWEN_DB_GetCharValue(db, "category", 0, 0);
          if (pid) {
            if (_isOfCategory(pid, _category)) {
              Transaction *t;

              t=new Transaction();
              if (!t->fromDb(db)) {
                DBG_ERROR(0, "Bad transaction, ignoring");
                GWEN_DB_Dump(db, stderr, 2);
              }
              else
                l.push_back(t);
            }
          }
          db=AH_Storage_GetNextTransaction(st, id);
        } // for transaction

        if (AH_Storage_CloseDay(st, id)) {
          DBG_ERROR(0, "Error closing day %04d/%02d/%02d",
                    year, month, day);
          GWEN_IdList_free(idl);
          return false;
        }

        ti=GWEN_Time_new(year, month-1, day, 0, 0, 0, 1);
        transactionsProgress->setProgress((int)((GWEN_Time_Seconds(ti)-
                                                 GWEN_Time_Seconds(ft)
                                                )/
                                                (60*60*24)));
        GWEN_Time_free(ti);

        rv=AH_Storage_GetNextDay(st, idl, &year, &month, &day);
      } /* while !rv */
      GWEN_Time_free(ft);
    } /* if first day */
    GWEN_IdList_free(idl);

    accnt++;
    accountsProgress->setProgress(accnt);
  } // for account

  accountsProgress->setTotalSteps(1);
  accountsProgress->setProgress(1);
  transactionsProgress->setTotalSteps(1);
  transactionsProgress->setProgress(1);

  return true;
}






