/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: categoryview.cpp 383 2006-02-08 15:03:39Z cstim $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "categoryview.h"
#include "categorywidget.h"
#include "categorylist.h"
#include "calccategory.h"
#include "transactionwindow.h"
#include "kbanking.h"

#include <qpushbutton.h>
#include <qlayout.h>
#include <qmessagebox.h>



CategoryView::CategoryView(KBanking *kb,
                           QWidget* parent,
                           const char* name, WFlags fl)
:CategoryWidget(parent, name, fl)
,_app(kb)
,_calculateButton(0)
,_calculateAllButton(0)
,_transactionsButton(0){
  QSpacerItem* spacer;

  CategoryWidget::init(kb);

#if (QT_VERSION >= 0x040000)
  // Current qt4-uic3 ignores the actual layout names
#  define buttonLayout vboxLayout2
#endif

  spacer=new QSpacerItem(21, 20, QSizePolicy::Minimum, QSizePolicy::Fixed);
  buttonLayout->addItem(spacer);

  _calculateButton=new QPushButton(this, "calculateButton" );
  _calculateButton->setText(tr("Calculate"));
  buttonLayout->addWidget(_calculateButton);

  _calculateAllButton=new QPushButton(this, "calculateAllButton" );
  _calculateAllButton->setText(tr("Calculate All"));
  buttonLayout->addWidget(_calculateAllButton);

  _transactionsButton=new QPushButton(this, "transactionsButton" );
  _transactionsButton->setText(tr("Transactions"));
  buttonLayout->addWidget(_transactionsButton);

  categoryListView->setUseColoursForText(kb->useColoursForCategoryText());

  QObject::connect(kb->flagStaff(),
                   SIGNAL(signalCategoriesUpdated()),
                   this, SLOT(slotUpdated()));


  QObject::connect(_transactionsButton, SIGNAL(clicked()),
                   this, SLOT(slotTransactions()));
  QObject::connect(_calculateButton, SIGNAL(clicked()),
                   this, SLOT(slotCalc()));
  QObject::connect(_calculateAllButton, SIGNAL(clicked()),
                   this, SLOT(slotCalcAll()));

}



CategoryView::~CategoryView() {
}



bool CategoryView::init() {
  GWEN_DB_NODE *db;

  categoryListView->beginModify();
  db=_app->getAppData();
  if (db) {
    db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                        "gui/views/CategoryView/dynamic");
    if (db) {
      GWEN_DB_NODE *dbT;

      dbT=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST, "categoryList");
      if (dbT) {
        const char *p;
        int i, j;

        /* found settings */
        i=GWEN_DB_GetIntValue(dbT, "sortColumn", 0, -1);
        if (i!=-1)
          categoryListView->setSortColumn(i);
        p=GWEN_DB_GetCharValue(dbT, "sortOrder", 0, "ascending");
        if (p) {
          if (strcasecmp(p, "ascending")==0)
            categoryListView->setSortOrder(Qt::Ascending);
          else
            if (strcasecmp(p, "descending")==0)
              categoryListView->setSortOrder(Qt::Descending);
        }
        for (i=0; i<categoryListView->columns(); i++) {
          categoryListView->setColumnWidthMode(i, QListView::Manual);
          j=GWEN_DB_GetIntValue(dbT, "columns", i, -1);
          if (j!=-1)
            categoryListView->setColumnWidth(i, j);
        } /* for */
      } // if category list data

    }
  }
  categoryListView->endModify();
  updateList();
  return true;
}



bool CategoryView::fini() {
  GWEN_DB_NODE *db;
  GWEN_DB_NODE *dbT;
  int i, j;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS,
                      "gui/views/CategoryView/dynamic");
  assert(db);

  // store category list info
  dbT=GWEN_DB_GetGroup(db, GWEN_DB_FLAGS_OVERWRITE_GROUPS, "categoryList");
  GWEN_DB_SetIntValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                      "sortColumn", categoryListView->sortColumn());
  switch(categoryListView->sortOrder()) {
  case Qt::Ascending:
    GWEN_DB_SetCharValue(dbT, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "sortOrder", "ascending");
    break;
  case Qt::Descending:
    GWEN_DB_SetCharValue(dbT, GWEN_DB_FLAGS_OVERWRITE_VARS,
                         "sortOrder", "descending");
    break;
  default:
    break;
  }
  GWEN_DB_DeleteVar(dbT, "columns");
  for (i=0; i<categoryListView->columns(); i++) {
    j=categoryListView->columnWidth(i);
    GWEN_DB_SetIntValue(dbT, GWEN_DB_FLAGS_DEFAULT,
                        "columns", j);
  } /* for */
  return true;
}



void CategoryView::slotUpdated() {
  categoryListView->setUseColoursForText(_app->useColoursForCategoryText());
  CategoryWidget::rebuildList();
}



void CategoryView::slotTransactions() {
  Category *p;
  std::list<Category*> pl;

  pl=categoryListView->getSelectedCategories();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No category selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }
  p=pl.front();

  std::list<RefPointer<Transaction> > l;
  CalculateCategory cp(_app, p);
  cp.show();
  if (cp.getTransactions(l)) {
    TransactionWindow *tv;

    tv=new TransactionWindow(_app, l,
                             "CategoryTransactions",
                             0,
                             "TransactionWindow",
                             Qt::WDestructiveClose);
    tv->setCaption(tr("Transactions"));
    if (!tv->init()) {
      QMessageBox::critical(this,
                            tr("Internal Error"),
                            tr("Could not initialize transaction view."),
                            tr("Dismiss"), QString::null);
      delete tv;
      return;
    }
    tv->show();
  }
}



void CategoryView::slotCalc() {
  Category *p;
  AB_VALUE *value;

  std::list<Category*> pl;
  pl=categoryListView->getSelectedCategories();
  if (pl.empty()) {
    QMessageBox::warning(this,
                         tr("Error"),
                         tr("<qt>"
                            "No category selected."
                            "</qt>"),
                         tr("Dismiss"), QString::null);
    return;
  }
  p=pl.front();

  value=AB_Value_new(0.0, 0);

  CalculateCategory cp(_app, p, value);
  cp.show();
  if (cp.calculate()) {
    p->resetValues();
    p->addValue(value);
    _app->flagStaff()->categoriesUpdated();
  }
  AB_Value_free(value);
}



void CategoryView::slotCalcAll() {
  CalculateCategory cp(_app);
  cp.show();
  cp.calculateAll();
}












