/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: stolist.h 212 2005-05-02 09:56:11Z aquamaniac $
    begin       : Fri Jul 12 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef STANDINGORDER_LIST_H
#define STANDINGORDER_LIST_H


#include <qlistview.h>
#include <qsimplerichtext.h>
#include <string>
#include "../prg/standingorder.h"
#include "../prg/refpointer.h"


#define STANDINGORDER_LISTVIEW_COLUMNS 6

class StandingOrderListView;
class StandingOrderListViewItem;


class StandingOrderListViewItem: public QListViewItem {
private:
  RefPointer<StandingOrder> _sto;
  QSimpleRichText *_cell[STANDINGORDER_LISTVIEW_COLUMNS];
  int _ht;
  std::string _colour;

  void _populate();

public:
  StandingOrderListViewItem(StandingOrderListView *parent,
                       RefPointer<StandingOrder> t);
  StandingOrderListViewItem(StandingOrderListView *parent,
                       QListViewItem *after,
                       RefPointer<StandingOrder>);
  StandingOrderListViewItem(const StandingOrderListViewItem &item);

  virtual ~StandingOrderListViewItem();

  RefPointer<StandingOrder> getStandingOrder();

  virtual void paintCell(QPainter * p,
                         const QColorGroup & cg,
                         int column,
                         int width,
                         int align);
  virtual int width(const QFontMetrics &,
                    const QListView *,
                    int column) const;
  virtual void setup();
  virtual QString key(int column, bool ascending) const;

  void redrawItem();

  void setColour(const QString &c);
};



class StandingOrderListView: public QListView {
  Q_OBJECT
private:
public:
  StandingOrderListView(QWidget *parent=0, const char *name=0);
  virtual ~StandingOrderListView();

  void addStandingOrder(RefPointer<StandingOrder> t);
  void addStandingOrders(const std::list<RefPointer<StandingOrder> > &ts);

  RefPointer<StandingOrder> getCurrentStandingOrder();
  std::list<RefPointer<StandingOrder> > getSelectedStandingOrders();

public slots:
  void slotHeaderChanged(int section,
                         int oldSize,
                         int newSize);

};



#endif //STANDINGORDER_LIST_H







