/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "editpayee.h"
#include "transfinder.h"
#include "ruleeditor.h"

#include "payee.h"
#include "kbanking.h"

#include <qlineedit.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qmessagebox.h>



EditPayee::EditPayee(KBanking *kb,
                     Payee *payee,
                     bool readOnly,
                     QWidget* parent,
                     const char* name,
                     bool modal,
                     WFlags fl)
:EditPayeeUi(parent, name, modal, fl)
,_app(kb)
,_payee(payee)
,_readOnly(readOnly)
,_countries(0){
  nameEdit->setEnabled(!_readOnly);
  streetEdit->setEnabled(!_readOnly);
  zipEdit->setEnabled(!_readOnly);
  cityEdit->setEnabled(!_readOnly);
  stateEdit->setEnabled(!_readOnly);

  bankCodeEdit->setEnabled(!_readOnly);
  accountNumberEdit->setEnabled(!_readOnly);
  phoneEdit->setEnabled(!_readOnly);
  faxEdit->setEnabled(!_readOnly);
  emailEdit->setEnabled(!_readOnly);
  countryCombo->setEnabled(!_readOnly);

  ruleEditor->init(kb, _payee->rules(), readOnly, 0);
  payeeToGui();
}



EditPayee::~EditPayee(){
}



void EditPayee::payeeToGui(){
  std::list<std::string>::iterator it;

  _countries=AB_Banking_ListCountriesByName(_app->getCInterface(), "*");
  countryCombo->clear();
  countryCombo->insertItem(tr("-- select country --"));
  if (_countries) {
    AB_COUNTRY_CONSTLIST2_ITERATOR *cit;

    DBG_DEBUG(0, "Have %d entries",
              AB_Country_ConstList2_GetSize(_countries));
    cit=AB_Country_ConstList2_First(_countries);
    if (cit) {
      const AB_COUNTRY *cnt;
      int idx=0;
      int i=0;

      cnt=AB_Country_ConstList2Iterator_Data(cit);
      assert(cnt);
      while(cnt) {
        const char *s;

        i++;
        s=AB_Country_GetLocalName(cnt);
        if (s==0) {
          countryCombo->insertItem(tr("unknown"));
        }
        else {
          if (idx==0 && strcasecmp(s, _payee->country().c_str())==0)
            idx=i;
          countryCombo->insertItem(QString::fromUtf8(s));
        }
        cnt=AB_Country_ConstList2Iterator_Next(cit);
      } // while */
      AB_Country_ConstList2Iterator_free(cit);
      if (idx)
        countryCombo->setCurrentItem(idx);
    } // if cit
  } // if _countries

  nameEdit->setText(QString::fromUtf8(_payee->name().c_str()));
  streetEdit->setText(QString::fromUtf8(_payee->street().c_str()));
  zipEdit->setText(QString::fromUtf8(_payee->zipCode().c_str()));
  cityEdit->setText(QString::fromUtf8(_payee->city().c_str()));
  stateEdit->setText(QString::fromUtf8(_payee->state().c_str()));

  bankCodeEdit->setText(QString::fromUtf8(_payee->bankCode().c_str()));
  accountNumberEdit->setText(QString::fromUtf8(_payee->accountNumber().c_str()));
  phoneEdit->setText(QString::fromUtf8(_payee->phone().c_str()));
  faxEdit->setText(QString::fromUtf8(_payee->fax().c_str()));
  emailEdit->setText(QString::fromUtf8(_payee->email().c_str()));
}



void EditPayee::guiToPayee(){
  GWEN_DB_NODE *dbRules;

  _payee->setName(KBanking::QStringToUtf8String(nameEdit->text()));
  _payee->setStreet(KBanking::QStringToUtf8String(streetEdit->text()));
  _payee->setZipCode(KBanking::QStringToUtf8String(zipEdit->text()));
  _payee->setCity(KBanking::QStringToUtf8String(cityEdit->text()));
  _payee->setState(KBanking::QStringToUtf8String(stateEdit->text()));
  if (countryCombo->currentItem()==0)
    _payee->setCountry("");
  else
    _payee->setCountry(KBanking::QStringToUtf8String(countryCombo->currentText()));
  _payee->setBankCode(KBanking::QStringToUtf8String(bankCodeEdit->text()));
  _payee->setAccountNumber(KBanking::QStringToUtf8String(accountNumberEdit->text()));
  _payee->setPhone(KBanking::QStringToUtf8String(phoneEdit->text()));
  _payee->setFax(KBanking::QStringToUtf8String(faxEdit->text()));
  _payee->setEmail(KBanking::QStringToUtf8String(emailEdit->text()));

  dbRules=_payee->rules();
  GWEN_DB_ClearGroup(dbRules, 0);
  GWEN_DB_AddGroupChildren(dbRules, ruleEditor->getRules());
}



void EditPayee::accept(){
  guiToPayee();
  return QDialog::accept();
}



