/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifndef QBANKMANAGER_BANKING_H
#define QBANKMANAGER_BANKING_H

#include <qbanking/qbanking.h>

#include <qobject.h>
#include <list>

class KBanking;
class TransactionWindow;
class MainWindow;
class WaitCallback;
class CfgModuleQbm;

#include <qbanking/qbanking.h>

#include "app.h"
#include "report.h"
#include "flagstaff.h"
#include "transfer.h"
#include "refpointer.h"


class KBanking: public App {
private:
  MainWindow *_mainWindow;
  uint32_t _lastWidgetId;
  GWEN_LOGGER_LEVEL _logLevel;
  FlagStaff *_flagStaff;
  CfgModuleQbm *_cfgModule;
  AB_JOB_LIST2 *_jobQueue;

  std::list<RefPointer<TransactionWindow> > _tWindows;

  /* variables from config file */
  std::list<Report*> _reports;
  bool _useColoursForCategoryText;
  unsigned int _lastReportId;

  /* private functions */
  void _sampleReportModules();
  int _newTransferJob(Transfer::TransferType tt,
                      RefPointer<Transfer> tmpl,
                      AB_JOB **retjob,
                      QWidget *parent=0);
  int _newTransfer(RefPointer<Transfer> tmpl=0, QWidget *parent=0);
  int _newDebitNote(RefPointer<Transfer> tmpl=0, QWidget *parent=0);
  int _newEuTransfer(RefPointer<Transfer> tmpl=0, QWidget *parent=0);
  int _newStandingOrderJob(RefPointer<Transaction> tmpl,
                           AB_JOB **retjob,
                           QWidget *parent);
  int _newDatedTransferJob(RefPointer<Transaction> tmpl,
                           AB_JOB **retjob,
                           QWidget *parent);

protected:
  virtual void infoTransactionsChanged(Account *a);

public:
  KBanking(const char *appname,
           const char *fname=0,
           const char *name=0);
  virtual ~KBanking();


  int init();
  int fini();

  FlagStaff *flagStaff();

  virtual bool importContext(AB_IMEXPORTER_CONTEXT *ctx,
                             uint32_t flags);
  void setMainWindow(MainWindow *w);
  MainWindow * getMainWindow();

  virtual std::string tr(const char *s);

  bool setTabWidget(const QString &name);

  int executeQueue(AB_IMEXPORTER_CONTEXT *ctx);

  void transfersUpdated();
  void standingOrdersUpdated();

  void rebuildExportMenu();

  void addTransactionWindow(TransactionWindow *w);
  void delTransactionWindow(TransactionWindow *w);
  void delTransactionWindows();

  bool useColoursForCategoryText() const;
  void setUseColoursForCategoryText(bool b);

  Report *findReport(const char *name);
  std::list<Report*> getReports();

  /** TODO: this method provoke memory leaks because the callers don't release the result!! */
  GWEN_DB_NODE *findReportProfile(Report *r, const char *id);

  /** TODO: this method provoke memory leaks because the callers don't release the result!! */
  GWEN_DB_NODE *getReportProfiles(Report *r);
  /** takes over ownership of the given group */
  int addReportProfile(Report *r, GWEN_DB_NODE *db);
  void removeReportProfile(Report *r,
                           GWEN_DB_NODE *dbProfile);


  int transferFromTemplate(RefPointer<Transaction> tmpl,
                           QWidget *parent);
  int euTransferFromTemplate(RefPointer<Transaction> tmpl,
                              QWidget *parent);
  int debitNoteFromTemplate(RefPointer<Transaction> tmpl,
                            QWidget *parent);
  int standingOrderFromTemplate(RefPointer<Transaction> tmpl,
                                QWidget *parent);
  int datedTransferFromTemplate(RefPointer<Transaction> tmpl,
                                QWidget *parent);


  int enqueueJob(AB_JOB *j);
  int dequeueJob(AB_JOB *j);
  std::list<AB_JOB*> getEnqueuedJobs();

};




#endif /* QBANKMANAGER_BANKING_H */


