/***************************************************************************
                          rcombobox.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rcombobox.h 1998/09/19 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RCOMBOBOX_H
#define RCOMBOBOX_H

#include <qcombobox.h>
#include <qlist.h>
#include <qstring.h>

#include "rgraphdef.h"

#include "rprgdef.h"

class RGraphic;

class RComboBox : public QComboBox
{
  Q_OBJECT
public:
  RComboBox(QWidget* _parent=0, const char* _name=0);
  RComboBox(bool _rw, QWidget* _parent=0, const char* _name=0);
  ~RComboBox();
  
  virtual void setEditText(const QString& _txt);
  virtual void setValue( double _val );
  virtual void setValue( int _val );
  void setParameter(const char* _txt);
  void insertItem(const QString& _t, int _index=-1);
  int  findItem(const QString& _t);
  void removeItem(const QString& _t);
  void removeItem(int _index) { QComboBox::removeItem(_index); }

  bool fillInMachineGenerators(bool _clear=true);
  bool fillInLayers(RGraphic* _graphic, bool _all, bool _clear=true);
  bool fillInColors(bool _clear=true);
  bool fillInWidths(bool _clear=true);
  bool fillInStyles(bool _clear=true);
  bool fillInParameters(const char* _mach, bool _layerParameters=true, bool _clear=true);
  bool fillInOrders(const char* _mach, bool _clear=true);
  bool fillInOrderItems(QList<QString> &_order, const char* _exception=0, bool _clear=true);
  bool fillInItemsFrom(RComboBox* _source, bool _clear=true);
  bool fillInItemsFromString(const char* _str, bool _clear=true);
  bool fillInIfItems(bool _clear=true);
  bool fillInFonts(bool _clear=true);
  bool fillInPatterns(bool _clear=true);
  bool fillInUnits(bool _clear=true);
  bool fillInExactness(bool _metric, bool _clear=true);
  bool fillInScale(bool _metric, ScaleType _type, bool _clear=true );
  bool fillInScaleTypes(bool _metric, bool _clear=true);
  bool fillInPageFormats(bool _clear=true);
  bool fillInPageOrientations(bool _clear=true);
  bool fillInCharsets(bool _clear=true);

private: 
  bool   readWrite;

};


#endif

// EOF

