/***************************************************************************
                          rlistboxitem.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rlistboxitem.cpp 1998/09/06 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qpainter.h>

#include "rlistboxitem.h"

// Constructor:
//
RListBoxItem::RListBoxItem(const QString& _text, const QPixmap _pixmap)
  : QListBoxItem(), pm(_pixmap)
{
  setText(_text);
}



// Destructor:
//
RListBoxItem::~RListBoxItem()
{

}


// Paint the item (text & pixmap):
//
void 
RListBoxItem::paint(QPainter *_painter)
{
  _painter->drawPixmap(3, 0, pm);
  QFontMetrics fm = _painter->fontMetrics();
  int yPos;                       // vertical text position
  if(pm.height() < fm.height()) {
    yPos = fm.ascent() + fm.leading()/2;
  }
  else {
    yPos = pm.height()/2 - fm.height()/2 + fm.ascent();
  }
  _painter->drawText( pm.width() + 5, yPos, text() );
}



// Get the height of this item:
//
int 
RListBoxItem::height(const QListBox* lb) const
{
  int textHeight=lb->fontMetrics().lineSpacing()+1;
  if(pm.height() > textHeight) {
    return pm.height();
  }
  else {
    return textHeight;
  }
}



// Get the width of this item:
//
int 
RListBoxItem::width(const QListBox* lb) const
{
  return pm.width() + lb->fontMetrics().width(text()) + 6;
}


// EOF


