#!/usr/bin/env python
# coding=utf-8

##    Qemulator - a qemu gui written in python and GTK/Glade.
##    Copyright (C) 2006  rainer haage
##
##    This program is free software; you can redistribute it and/or
##    modify it under the terms of the GNU General Public License
##    as published by the Free Software Foundation; either version 2
##    of the License, or (at your option) any later version.
##    
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##    
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

class Network:        
    def __init__(self):
        #shcommand = "sh " + pts
        self.ntype = ""
        #self.nnumber = nnumber
        self.ip = ""
        self.port = "1"
        self.mac = ""
        self.vlan = "0"
        self.ttscript = ""
        self.ifname = ""
        self.ttfiledesc = ""
            
            
    def create_qemucommand(self):
        qemucommand = ""
        macommand = ""
        if self.mac != "":
            macommand = ",macaddr=" + self.mac
        ttscript_command = ""
        if self.ttscript != "":
            ttscript_command = ",script=" + str(self.ttscript)
        fdcommand = ",fd=" + str(self.ttfiledesc)
        listencommand = ",listen=" + str(self.ip) + ":" + str(self.port)
        connectcommand = ",connect=" + str(self.ip) + ":" + str(self.port)
        mcastcommand = ",mcast=" + str(self.ip) + ":" + str(self.port)
        ## build qemu commandlines for each setup    
        if self.ntype == "Open a TUN/TAP interface":
            #qemucommand = "-net nic,vlan=0,macaddr=3f:ff:2e:23:33:9d -net tap,vlan=0,ifname=net1,script=/dev/null"    
            #qemucommand = "-net nic,vlan=" + self.vlan + macommand + " -net tap,vlan=" + self.vlan + ",ifname=" + self.ifname + ",script=" + self.ttscript
            qemucommand = " -net nic,vlan=" + str(self.vlan) + macommand + " -net tap,vlan=" + str(self.vlan) + ",ifname=" + self.ifname + ttscript_command + " "
        elif self.ntype == "Use an already open TUN/TAP interface":
            qemucommand = " -net nic,vlan=" + str(self.vlan) + macommand + " -net tap,vlan=" + str(self.vlan) + fdcommand
        elif self.ntype == "Open a listening TCP socket":
            qemucommand = " -net nic,vlan=" + str(self.vlan) + macommand + " -net socket,vlan=" + str(self.vlan) + listencommand
        elif self.ntype == "Use an already open TCP socket":
            qemucommand = " -net nic,vlan=" + str(self.vlan) + macommand + " -net socket,vlan=" + str(self.vlan) + fdcommand
        elif self.ntype == "Connect to listening  TCP socket":
            qemucommand = " -net nic,vlan=" + str(self.vlan) + macommand + " -net socket,vlan=" + str(self.vlan) + connectcommand
        elif self.ntype == "Create shared VLAN via UDP multicast socket":  
            qemucommand = " -net nic,vlan=" + str(self.vlan) + macommand + " -net socket,vlan=" + str(self.vlan) + mcastcommand
        elif self.ntype == "Use an already open UDP multicast socket":
            qemucommand = " -net nic,vlan=" + str(self.vlan) + macommand + " -net socket,vlan=" + str(self.vlan) + fdcommand
        else:
            pass   
        return qemucommand

class Network_Usernet:        
    def __init__(self):
        self.vlan = "0"
        self.hostname = "emu"
        #print "VLAN: " + str(self.vlan)
             
    def create_qemucommand(self): 
        #qemucommand = " -net nic,vlan=" + str(self.vlan) + " -net user,vlan=" + str(self.vlan) + ",hostname=" + str(self.hostname) + " "
        qemucommand = " -net nic,vlan=" + str(self.vlan) + " -net user,vlan=" + str(self.vlan) + ",hostname=" + str(self.hostname)
        return qemucommand    
    
class Network_SMB:        
    def __init__(self):
        self.usesmb = False
        self.smbpath = ""
        #print "VLAN: " + str(self.vlan)
             
    def create_qemucommand(self): 
        if self.usesmb == True:
            #qemucommand = " -smb " + str(self.smbpath) + " "
            qemucommand = " -smb " + str(self.smbpath)
        else:
            qemucommand = " "            
        return qemucommand     
                                             
    
class Network_Redirection:        
    def __init__(self):
        #shcommand = "sh " + pts
        self.protocol = ""
        #self.nnumber = nnumber
        self.sport = "1"
        self.ip = ""            
        self.dport = "1"
            
    def create_qemucommand(self): 
        qemucommand = " -redir " + str(self.protocol) + ":" + str(self.sport) + ":" + str(self.ip) + ":" + str(self.dport) + " "
        qemucommand = " -redir " + str(self.protocol) + ":" + str(self.sport) + ":" + str(self.ip) + ":" + str(self.dport)
        return qemucommand