/*
 * CCameraKeyPathAttributes.h
 * $Id: 
 *
 * Copyright (C) 2001 Alexander Buck
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class CCameraKeyPathAttributes
//  Purpose     : Save attributes for a CameraKeyPath

#ifndef CCAMERAKEYPATHATTRIBUTES_H
#define CCAMERAKEYPATHATTRIBUTES_H

/** Saves attributes for a CameraKeyPath

  @author Alexander Buck
*/

class CCameraKeyPathAttributes
{
 public:

  //////////////////
  // CONSTRUCTORS //
  //////////////////

  /** default constructor. */
  CCameraKeyPathAttributes(int frames = 10,float tension = 0.0,float con = 0.0,float bias = 0.0);

  /** default destructor. */
  ~CCameraKeyPathAttributes();

  //////////////////////
  // MEMBER FUNCTIONS //
  //////////////////////

  /** Returns framerate. */
  int getFrames() const
    {
      return m_nFrames;
    };

  /** Returns tension. */
  float getTension() const 
    {
      return m_rfTension;
    };

  /** Returns continuity. */
  float getContinuity() const
    {
      return m_rfContinuity;
    };

  /** Returns bias. */
  float getBias() const 
    {
      return m_rfBias;
    };

  /** Set attributes. */
  void setAttributes(int nFrames,float rfTension, float rfContinuity, float rfBias);

  /** Set framerate. */
  void setFrames(int);

  /** Set tension. */
  void setTension(float);

  /** Set continuity. */
  void setContinuity(float);

  /** Set bias. */
  void setBias(float);

 protected:
  ///////////////////////
  // PROTECTED MEMBERS //
  ///////////////////////

  /** Current framerate. */
  int m_nFrames;         

  /** Current tension. */
  float m_rfTension;      

  /** Current continuity. */
  float m_rfContinuity;   

  /** Current bias. */
  float m_rfBias;         
};

#endif // CCAMERAKEYPATHATTRIBUTES_H
