/*
 * QGLViewerIO.h
 * $Id:
 *
 * Copyright (C) 2001 Alexander Buck, Thomas Woerner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class QGLViewerIO
//  Purpose     : Provides methods to read and write different things

#ifndef __QGLVIEWERIO_H
#define __QGLVIEWERIO_H


// Forward declarations
///////////////////////////
class QFile;
template <class T> class CList;
class CCameraKeyPathPoint;
class CCamera;



/** This class provides methods to read and write
  * different things that belong to the QGLViewer and
  * its tools.
  *
  * @author Alexander Buck, Thomas Woerner, Markus Janich
  *
  * @version 0.0 //see cvs docu
  *
  */

class QGLViewerIO {
public:

  //////////////////////
  // MEMBER FUNCTIONS //
  //////////////////////

  /** Reads a CameraKeyPath from a file. */
  static bool read(QFile &, CList<CCameraKeyPathPoint> &);

  /** Writes a CameraKeyPath to a file. */  
  static bool write(QFile &, CList<CCameraKeyPathPoint> &);

  /** Reads QFile to CList<CCamera>. 
    * The number of converted CCameras is returned. */
  static bool read(QFile &, CList<CCamera> &);

  /** Writes CList<CCamera> to QFile. 
    * The number of converted CCameras is returned. */
  static bool write(QFile &, CList<CCamera> &);
};

#endif // __QGLVIEWERIO_H
