/*
 * QGLViewerSceneTreeObjects.h
 * $Id: 
 *
 * Copyright (C) 2001 Richard Guenther, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Different general node types to put into a scene tree
//  Purpose     : what do you think about


#ifndef __QGLVIEWERSCENETREEOBJECTS_H
#define __QGLVIEWERSCENETREEOBJECTS_H


// Qt
/////////
#include <qcolor.h>


// Own
/////////
#include "QGLViewer.h"
#include "QSceneTreeNode.h"
#include "CLightSource.h"
#include "CList.h"

/** Node that manages a list of lights.
  *
  * @author Richard Guenther
  */
class STLightList : public QSceneTreeDrawable
{
public:
  /** Constructs a node with the given list of lights.
    * \par NOTE: A full duplicate of the list is made.
    *            So you'reallowed to delete the original
    *            list after the call of this constructor. */
  STLightList(const CList<CLightSource> *pLightList);
  /** Constructs a node with only one light. */
  STLightList(const CLightSource &Light);

  /** Destructor. */
  ~STLightList();

  /** Implementation of the inherited method. It makes
    * all necessary OpenGL calls to enable all lights
    * in the list. */
  virtual void draw();

private:
  CList<CLightSource> *m_pLightList;
};


/** Node that manages a 3D bounding box.
  *
  * @author Richard Guenther, Markus Janich
  */
class STQGLViewerBoundingBox : public CBoundingBox3D, public QSceneTreeDrawable
{
public:
  /** Construct a node with the given bounding box. */
  STQGLViewerBoundingBox(const CBoundingBox3D &cBBox);

  /** Implementation of the inherited method. It renders
    * the bounding box to the current OpenGL context. */
  virtual void draw();

private:
  GLuint m_nDispList;
};


/** Node that manages a OpenGl display list.
  *
  * @author Markus Janich
  */
class STDisplayList : public QSceneTreeDrawable
{
public:
  /** Constructor.
    *
    * 'nDisplist' is the value, that is returned by the
    * OpenGL call 'glGenLists(...)'.
    * The color given by 'qRgba' is set before the
    * display list is drawn. It defines the ambient
    * and diffuse part of lighting calculations. But the
    * color could change if you change it inside the display list.
    * \par NOTE: Don't free the display list by  using
    *            'glDeleteLists(...)', because this is
    *            already done by the destructor !
    */
  STDisplayList(GLuint nDispList, QRgb rgba = qRgba(255,255,255,255)) 
    : m_nDispList(nDispList),
      m_qRgba(rgba)
    {};
  /** Destructor. */
  ~STDisplayList();

  /** Implementation of the inherited method. It renders
    * the display list to the current OpenGL context. */
  virtual void draw();

  /** Returns the current color. */
  QRgb getRGBA() { return m_qRgba; };

  /** Sets the color. */
  void setRGBA(QRgb qRgba) { m_qRgba = qRgba; };


private:
  GLuint m_nDispList;
  QRgb m_qRgba;
};


/*
class STProxy : public QObject, public QSceneTreeDrawable
{
  Q_OBJECT

public:
  STProxy();
  ~STProxy();

  virtual void draw() { emit(sigRedrawGL()); };

signals:
  void sigRedrawGL();

public slots:
  void sltUpdateView() { requestUpdate(); };
};
*/


#endif  // __QGLVIEWERSCENETREEOBJECTS_H
