/*
 * QCameraDrag.cpp
 * $Id: QCameraDrag.cpp,v 1.3 2001/11/15 16:54:53 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

// Qt
///////
#include <qevent.h>
#include <qdom.h>


// System
///////////
#include <string.h>


// Own
///////////
#include "QCameraDrag.h"
#include "CCamera.h"
#include "QGLViewerXML.h"


using namespace QGLViewerXML;


// initialization of static members
const char *QCameraDrag::picture_xpm[] = {
   "16 16 3 1",
   "       c None",
   ".      c #FFFFFF",
   "X      c #000000",
   "     ..    ..   ",
   "    .XX.  .XX.  ",
   "   .XXXX..XXXX. ",
   "   .XXXX..XXXX. ",
   "..  .XX....XX.  ",
   ".X..XXXXXXXXXX. ",
   ".XX.XXXXXXXXXX. ",
   ".XXXXXXXXXXXXX. ",
   ".XX.XXXXXXXXXX. ",
   ".X..XXXXXXXXXX. ",
   "..  ..XX..XX..  ",
   "     .XX..XX.   ",
   "    .XX.  .XX.  ",
   "   .XX.    .XX. ",
   "  .XX.      .XX.",
   " ....        ..."};



// Function  : QCameraDrag
// Parameters: const CCamera *pcCamera, QWidget *parent, const char *name
// Purpose   : default constructor.
// Comments  : See docu for details.
QCameraDrag::QCameraDrag(const CCamera *pcCamera, QWidget *parent, const char *name)
  : QStoredDrag( "glviewer/camera", parent, name )
/*********************************************************************/
{
   QDomDocument qDoc("CCamera");
   QDomElement qDocRootElem = qDoc.createElement(QString("CCamera"));
   qDoc.appendChild(qDocRootElem);

   writeXML(qDocRootElem, *pcCamera);

   setEncodedData(qDoc.toCString());
}



// Function  : ~QCameraDrag
// Parameters: 
// Purpose   : default destructor.
// Comments  : See docu for details.
QCameraDrag::~QCameraDrag() 
/*********************************************************************/
{
   /* nothing to do */
}



// Function  : canDecode
// Parameters: QDragMoveEvent *event
// Purpose   : 
// Comments  : See docu for details.
bool QCameraDrag::canDecode(QDragMoveEvent *pqEvent) 
/*********************************************************************/
{
   return pqEvent->provides("glviewer/camera");
}



// Function  : decode
// Parameters: QDropEvent *event, CCamera &cCamera
// Purpose   : 
// Comments  : See docu for details.
bool QCameraDrag::decode(QDropEvent *pqEvent, CCamera &cCamera) 
/*********************************************************************/
{
   QByteArray data = pqEvent->data("glviewer/camera");
   if (data.size()) {
      QDomDocument doc("CCamera");
      doc.setContent(QCString(data));

      if(readXML(doc.documentElement(), cCamera)) {
	pqEvent->accept();
	return true;
      }
   }

   return false;
}
