/***************************************************************************
 *   Copyright (C) 2007 by Matvey Kozhev                                   *
 *   sikon@lucidfox.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ENVMAP_H
#define ENVMAP_H

#include <QObject>
#include <QString>
#include <QMap>
#include <QProcess>

/**
	@author Sikon <sikon@lucidfox.org>
*/
class EnvMap : public QObject
{
Q_OBJECT
public:
    EnvMap(QProcess *process = 0);
    ~EnvMap();
    void reload();
    QString at(const QString& key, const QString& def = QString()) const;

protected:
    QMap< QString, QString > map() const
    {
        return _map;
    }

private:
    QMap<QString, QString> _map;
    QProcess *_process;
};

#endif
