/***************************************************************************
 *   Copyright (C) 2003 by Moris Ravasio                                   *
 *   moris_ravasio@hotmail.com                                             *
 *                                                                         *
 *   Copyright (C) 2007 by Matvey Kozhev                                   *
 *   sikon@lucidfox.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef QINKDLG_H
#define QINKDLG_H

#include "qink.h"
#include "ui_QinkDlg.h"
#include "device.h"

#include <QSystemTrayIcon>

class QInkDlg : public QDialog, private Ui::QInkDlg
{
    Q_OBJECT

    Device lastDevice;
    QVector<Device> devList;
    QSystemTrayIcon *trayIcon;
    QMap<int, QProgressBar *> barMap;
    QMap<int, QWidget *> groupMap;
    int _errorCode;
    
public:
    QInkDlg(QWidget* parent = 0);
    ~QInkDlg();

public slots:
//    virtual void close();

protected:

protected slots:
    virtual void cmbDevices_activated(const QString &);
    virtual void btnAdd_clicked();
    virtual void btnDetect_clicked();
    virtual void btnAbout_clicked();
    virtual void btnUpdate_clicked();
    virtual void btnClose_clicked();
    
    virtual void trayActivated(QSystemTrayIcon::ActivationReason reason);
    virtual void toggleVisibility();
    virtual void aboutQt();
    virtual void exit();

private:
    void initTrayIcon(const QIcon& icon);
    void initBarMap();
    void autoDetect();
    void query();
    void loadState();
    void saveState();
    void showError(QString errStr);
    void updateTooltip();
    void updateView();
};

#endif
