/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdlib.h>
#include <math.h>

#include <qlabel.h>
#include <qcanvas.h>

#include <common_functions.h>
#include <qpx_const.h>

#include "plextor_ext_cx.h"


const int egrids_CX = 26;

plextor_ext_cx::plextor_ext_cx( QWidget* parent, const char* name, bool modal, WFlags fl,
		int* BLER, int* E11, int* E21, int* E31, int* E12, int* E22, int* E32,
		int* blk_tot, int* blk_max, float* blk_avg, int* colors, int limit)
	:plextor_ext_cx_UI(parent, name, modal, fl)
{
	for (int i=0; i<7; i++) color[i] = colors[i];

	int i,j;
	unsigned char R,G,B;
//	printf("Canvas...\n");
	Canvas[0] = new QCanvas ( pix_BLER, "Canvas_BLER");
	Canvas[1] = new QCanvas ( pix_E11,  "Canvas_E11" );
	Canvas[2] = new QCanvas ( pix_E21,  "Canvas_E21" );
	Canvas[3] = new QCanvas ( pix_E31,  "Canvas_E31" );
	Canvas[4] = new QCanvas ( pix_E12,  "Canvas_E12" );
	Canvas[5] = new QCanvas ( pix_E22,  "Canvas_E22" );
	Canvas[6] = new QCanvas ( pix_E32,  "Canvas_E32" );
	for (i=0; i<7; i++) {
		Canvas[i]->setBackgroundColor ( white );
		Canvas[i]->setAdvancePeriod ( 100 );
		Canvas[i]->resize ( ehres, evres );
	}
//	printf("CanvasView...\n");
	CanvasView[0] = new QCanvasView ( Canvas[0], pix_BLER, "CanvasView0" );
	CanvasView[1] = new QCanvasView ( Canvas[1], pix_E11,  "CanvasView1" );
	CanvasView[2] = new QCanvasView ( Canvas[2], pix_E21,  "CanvasView2" );
	CanvasView[3] = new QCanvasView ( Canvas[3], pix_E31,  "CanvasView3" );
	CanvasView[4] = new QCanvasView ( Canvas[4], pix_E12,  "CanvasView4" );
	CanvasView[5] = new QCanvasView ( Canvas[5], pix_E22,  "CanvasView5" );
	CanvasView[6] = new QCanvasView ( Canvas[6], pix_E32,  "CanvasView6" );
//	printf("Lines...\n");
	Lim = (QCanvasLine**) malloc (7*sizeof(QCanvasLine*));
	for (i=0; i<7; i++) {
//		printf("Graph[%d]\n",i);
		CanvasView[i]->resize ( ehres+4, evres+4 );

		Lim[i] = new QCanvasLine(Canvas[i]);
		Lim[i]->setPen(QPen(QColor(0,0,0), 2, SolidLine));
		Lim[i]->show();

		Res[i] = (QCanvasLine**) malloc ((ehres)*sizeof(QCanvasLine*));
		R = (color[i] >> 16 ) & 0xFF;
		G = (color[i] >> 8 ) & 0xFF;
		B = (color[i]) & 0xFF;
//		printf("Color[%d] = (%02X, %02X, %02X)\n",i,R,G,B);
		for (j=0; j< ehres; j++) {
			Res[i][j] = new QCanvasLine(Canvas[i]);
			Res[i][j]->setPen(QPen(QColor(R, G, B), 1, SolidLine));
			Res[i][j]->setPoints(j,0,j,0);
			Res[i][j]->show();
		}

		Grid[i] = (QCanvasLine**) malloc (egrids_CX*sizeof(QCanvasLine*));
		for (j=0; j<grids_CX; j++)
			Grid[i][j] = new QCanvasLine(Canvas[i]);
		DrawGrid(i);
	}

	data[0] = BLER;
	data[1] = E11; data[2] = E21; data[3] = E31;
	data[4] = E12; data[5] = E22; data[6] = E32;
	dtot = blk_tot; dmax = blk_max; davg = blk_avg;

	hlimit = limit+1;
	for (int i=0; i<7; i++) Lim[i]->setPoints(hlimit/2, 0, hlimit/2,evres-1);

	redraw();
}

plextor_ext_cx::~plextor_ext_cx()
{
//	printf("destroing...\n");
	int i,j;
//	printf("Grid...\n");
	for (i=0; i<7; i++) { for (j=0; j<egrids_CX; j++) delete Grid[i][j]; delete Grid[i]; }
//	printf("Res...\n");
	for (i=0; i<7; i++) { for (j=0; j<ehres; j++) delete Res[i][j]; delete Res[i]; }
//	printf("Limits...\n");
	for (i=0; i<7; i++) delete Lim[i];
	delete Lim;
	for (i=0; i<7; i++) delete CanvasView[i];
	for (i=0; i<7; i++) delete Canvas[i];
}

void plextor_ext_cx::redraw(){
	int i,j;
	int p0,p1;
	int d0,d1;

	int h,l;
//	printf("redraw graph\n");
	for (i=0; i<7; i++)
		for (j=0; j<ehres; j++) {
			if (data[i][j*2]>0)   d0=(int)(50*(float)log10(data[i][j*2])+5);   else d0=1;
			if (data[i][j*2+1]>0) d1=(int)(50*(float)log10(data[i][j*2+1])+5); else d1=1;
			h = max(d0,d1);
			l = min(d0,d1);

			if (j>0) {
				if (data[i][j*2-2]>0) p0=(int)(50*(float)log10(data[i][j*2-2])+5); else p0=1;
				if (data[i][j*2-1]>0) p1=(int)(50*(float)log10(data[i][j*2-1])+5); else p1=1;
			} else { p0 = d0; p1 = d1; }

			h = max(h, (p0+p1)/2);
			l = min(h, (p0+p1)/2);
/*
			if (arr[i]>0) h=(int)(50*(float)log10(arr[i])+5);
			else h=1;
			if (h>=vres2) h=(vres2)-1; if (h<1) h=1;
			for (j=vres2-1 ; j>(vres2-h) ; j--) result_cx->setPixel(i,j,color);
*/
//			Res[i][j]->setPoints(j,evres-l,j,evres-h);
			Res[i][j]->setPoints(j,evres,j,evres-h);
/*
			if (j>hlimit) {
				Res[i][j]->setPoints(j,0,j,0);
			} else {
				l = data[i][j*2];
				h = data[i][j*2+1];
				Res[i][j]->setPoints(j,min(l,h),j,max(l,h));
			}
*/
		}

	bler_tot->setText(QString().sprintf("%d",dtot[0]));
	e11_tot->setText(QString().sprintf("%d",dtot[1]));
	e21_tot->setText(QString().sprintf("%d",dtot[2]));
	e31_tot->setText(QString().sprintf("%d",dtot[3]));
	e12_tot->setText(QString().sprintf("%d",dtot[4]));
	e22_tot->setText(QString().sprintf("%d",dtot[5]));
	e32_tot->setText(QString().sprintf("%d",dtot[6]));

	bler_max->setText(QString().sprintf("%d",dmax[0]));
	e11_max->setText(QString().sprintf("%d",dmax[1]));
	e21_max->setText(QString().sprintf("%d",dmax[2]));
	e31_max->setText(QString().sprintf("%d",dmax[3]));
	e12_max->setText(QString().sprintf("%d",dmax[4]));
	e22_max->setText(QString().sprintf("%d",dmax[5]));
	e32_max->setText(QString().sprintf("%d",dmax[6]));

	bler_avg->setText(QString().sprintf("%6.2f",davg[0]));
	e11_avg->setText(QString().sprintf("%6.2f",davg[1]));
	e21_avg->setText(QString().sprintf("%6.2f",davg[2]));
	e31_avg->setText(QString().sprintf("%6.2f",davg[3]));
	e12_avg->setText(QString().sprintf("%6.2f",davg[4]));
	e22_avg->setText(QString().sprintf("%6.2f",davg[5]));
	e32_avg->setText(QString().sprintf("%6.2f",davg[6]));
}

void plextor_ext_cx::DrawGrid(int idx){
	int	i;
	int	h[]={220, 10, 100, 1000, 50, 500, 20, 30, 40, 200, 300, 400, 2, 3, 4, 5};
	float	lh[18];
	for (i=0;i<16;i++) lh[i]=50*log10(h[i])+5; lh[16]=5;
	if (idx) lh[0]=0;
	for (i=0; i<1; i++) Grid[idx][i]->setPen(QPen(QColor(0xFF,0,0), 1, SolidLine));
	for (i=1; i<4; i++) Grid[idx][i]->setPen(QPen(QColor(0,0,0), 2, SolidLine));
	for (i=4; i<16;i++) Grid[idx][i]->setPen(QPen(QColor(0,0,0xFF), 1, SolidLine));
	Grid[idx][16]->setPen(QPen(QColor(0,0,0), 2, SolidLine));
	for (i=0; i<17; i++) {
		Grid[idx][i]->setPoints(0,evres-(int)lh[i],ehres,evres-(int)lh[i]);
		Grid[idx][i]->show();
	}
	for (i=0; i<9; i++) {
		Grid[idx][i+17]->setPen(QPen(QColor(0x80,0x80,0x80), 1, SolidLine));
		Grid[idx][i+17]->setPoints((i+1)*30,0,(i+1)*30,evres);
		Grid[idx][i+17]->show();
	}
}

void plextor_ext_cx::pxecx_close()
{
//	if (asdb_drive) delete asdb_drive;
//	printf("=== ASDB editor destroyed\n");
	this->close();
}
