/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef __QPxToolWidget
#define __QPxToolWidget 1

//#include <qcanvas.h>
#include <qfiledialog.h>
#include <qthread.h>
// #include <qobject.h>
#include <qpx_mmc.h>
#include <qmainwindow.h>
//#include <qhbox.h>

#include <test_threads.h>

#include "qpx_const.h"
#include <ui/QPxTool_ui.h>

#include "About.h"

class QCanvas;
class QCanvasLine;
class QCanvasView;
class QFileDialog;
class QObject;
class QProgressBar;
class QThread;
class plextor_ext_cx;
class watcher_thread;

const int CD_EXT_BLER = 0x01;
const int CD_EXT_E11  = 0x02;
const int CD_EXT_E21  = 0x03;
const int CD_EXT_E31  = 0x04;
const int CD_EXT_E12  = 0x05;
const int CD_EXT_E22  = 0x06;
const int CD_EXT_E32  = 0x07;

//class QPxTool_mainwin : public QPxTool_mainwin_UI
class QPxToolWidget : public QPxTool_mainwin_UI
{
	Q_OBJECT

public:
//	QPxToolWidget(QWidget* p = 0, const char* name = 0, WFlags fl = 0 );
//	QPxTool_mainwin(QWidget *parent, const char *name);
	QPxToolWidget(QWidget *parent, const char *name);
//	~QPxTool_mainwin();
	~QPxToolWidget();


	void	customEvent(QCustomEvent *event);

public slots:
	void	file_save();
	void	file_save_rd();
	void	file_save_cx();
	void	file_save_jb();
	void	file_save_ft();
	void	file_save_ta();
	void	quit();

	void	zero_rd();
	void	zero_cx();
	void	zero_cx0();
	void	zero_cx1();
	void	zero_jb();
	void	zero_ft();
	void	zero_ta();
	void	clear_all();
	void	clear_debug();

	void	scanbus();
	void	update_device_info();

	void	about();
private:
	void	updatePieC1Data(int c1t, int c1m, float c1a);
	void	updatePifC2Data(int c2t, int c2m, float c2a);
	void	updatePofCUData(int c3t, int c3m, float c3a);
	void	updateJBData(float jmax, float jmin, float javg, float bmax, float bmin, float bavg);

	void    DrawResRD(int idx, int spd);
	void    DrawRes0(int idx,int max, int min, int m, int d);
	void    DrawRes1(int idx,int max, int min, int m, int d);
	void    DrawRes2(int idx,int max, int min, int m, int d);
	void    DrawResJB(int idx, int jmin, int jmax, short int bmin, short int bmax);
	void	DrawResFT(int idx, int ofe, int ote, int nfe, int nte);
	void	DrawResTAP(int pass, int idx, int val);
	void	DrawResTAL(int pass, int idx, int val);

	void	select_device(const QString& drive);
	void	select_device();
	void	get_media_info(drive_info* drive);

	void	silent_mode_save();
	void	silent_mode_test();
	void	silent_mode_update(drive_info* drive);
	void	silent_mode_toggle(bool state);
	void	silent_mode_set_cd(const QString&);
	void	silent_mode_set_dvd(const QString&);
	void	silent_mode_set_access_time(const QString&);
	void	silent_mode_set_load(int load_speed);
	void	silent_mode_set_eject(int eject_speed);

	void	as_off_toggled(bool state);
	void	as_auto_toggled(bool state);
	void	as_forced_toggled(bool state);
	void	as_on_toggled(bool state);
	void	asdb_edit();
	void	mqck();

	void	pxerase_quick_toggled(bool state);
	void	pxerase_full_toggled(bool state);
	void	do_plexeraser();

	void	set_powerec_state(int state);
	void	show_powerec_speed();
	void	set_gigarec_state(int state);
	void	set_gigarec_value(const QString& value);
	void	set_varirec_state_cd(int state);
	void	set_varirec_state_dvd(int state);
	void	set_varirec_power_cd(const QString& power);
	void	set_varirec_power_dvd(const QString& power);
	void	set_varirec_strategy_cd(const QString&);
	void	set_varirec_strategy_dvd(const QString&);
	void	set_hcdr_state(int state);
	void	set_ss_state(int state);
	void	set_speedread_state(int state);
	void	set_bitset_r(int state);
	void	set_bitset_rdl(int state);
	void	set_simul_dvdplus(int state);
	void	securec_act_deact();
	void	check_securec_changed(int state);

	void	set_pioq_quiet(bool set);
	void	set_pioq_perf(bool set);
	void	set_pioq_std(bool set);
	void	set_pioneer_speedlimit_state(int state);
	void	pioq_save();

	void	set_scan_commands(const QString&);
	void	run_tests();
	void	skip_current_test();
	void	abort_tests();
	void	show_capabilities(drive_info* drive);
	int	print_disc_type(drive_info* drive); //(int media, int disc_type);
	int	print_book_type(drive_info* drive); //(int book_type);

//	void	set_scan_speed(const QString& speed);
	void	set_scan_speed(const QString&);
//	void	set_spindown_time(const QString& spindown);
	void	set_spindown_time(const QString&);
	void	show_spindown_time(drive_info* drive);
	void	lock(int state);
	void	do_load_eject();
	void	detect_speeds();
	void	set_speed(int speedidx);
	void	show_read_speed(drive_info* drive);

	void	toggle_c1pie(bool state);
	void	toggle_c2pif(bool state);
	void	toggle_cu(bool state);
	void	toggle_jitter(bool state);
	void	toggle_beta(bool state);
	void	toggle_fe(bool state);
	void	toggle_te(bool state);
	void	DrawTestLimits(int idx, int idx2);
	void	TA_show(int TA);
	void	TA_hide(int TA);
	void	TA_layer_0(bool show);
	void	TA_layer_1(bool show);
	void	TA_zone_0(bool show);
	void	TA_zone_1(bool show);
	void	TA_zone_2(bool show);
	void	TA_select_layer(const QString& qlayer);
	void	TA_select_zone(const QString& qzone);
	void	DrawGridRD(); //(int h, int dir);
	void	DrawGrid0(); //(int h, int dir);
//	void	DrawGrid1(); //(int h, int dir);
	void	DrawGridJB(); //(int h, int dir);
	void	DrawGridFT(); //(int h, int dir);
	void	DrawGridTA();

//	QThread*	QScanThread;

	void	end_tests();
	void	reset_progress();
//	void	test_started(int);
// 	void	test_finished();
	void	block_done_rd(block_data* block);
// 	void	block_done_wr(block_data* block);
	void	block_done_c1pie(block_data* block);
	void	block_done_c2pif(block_data* block);
	void	block_done_cupof(block_data* block);
	void	block_done_jb(block_data* block);
	void	block_done_fete(block_data* block);
	void	block_done_ta(block_data* block);
	void	block_done_cx_ext(block_data* block, int event_id);

	void	show_lba(block_data* block);
	void	showtime(block_data* block);
	void	media_changed(int didx, bool insert);
	void	draw_ext_cx();
	_Exx	Exx;

	QCanvas*	CanvasRD;
	QCanvasView*	CanvasViewRD;
	QCanvasLine**	GridRD;
	QCanvasLine**	RezRD;

	QCanvas*	Canvas0;
	QCanvasView*	CanvasView0;
	QCanvasLine**	Grid0;
	QCanvasLine**	Rez_00;
	QCanvasLine**	Rez_01;
	QCanvasLine**	Rez_10;
	QCanvasLine**	Rez_11;
	QCanvasLine**	Rez_20;
	QCanvasLine**	Rez_21;
// 	QCanvas*	Canvas1;
// 	QCanvasView*	CanvasView1;
//	QCanvasLine**	Grid1;


	QCanvas*	CanvasJB;
	QCanvasView*	CanvasViewJB;
	QCanvasLine**	GridJB;
	QCanvasLine**	RezJ;
	QCanvasLine**	RezB;

	QCanvas*	CanvasFT;
	QCanvasView*	CanvasViewFT;
	QCanvasLine**	GridFT;
	QCanvasLine**	RezFE;
	QCanvasLine**	RezTE;

	QCanvas*	CanvasTAP;
	QCanvasView*	CanvasViewTAP;
	QCanvasLine**	GridTAP;
	QCanvasLine**	RezTAP[6];

	QCanvas*	CanvasTAL;
	QCanvasView*	CanvasViewTAL;
	QCanvasLine**	GridTAL;
	QCanvasLine**	RezTAL[6];

	QCanvasLine*	Limits[5];

// -----------------
//	QMenuBar*	menubar;
// -----------------
	QPopupMenu*	menu_file;
	QPopupMenu*	menu_save;
	QPopupMenu*	menu_view;
	QPopupMenu*	menu_device;
	QPopupMenu*	menu_about;

	QProgressBar*	progress_test;
	QLabel*		status_current_test;
	QLabel*		status_media_type;
	QLabel*		status_MID;

// 	QPopupMenu*	menu_help;
	QPixmap		pix_logo;
	QPixmap		pix_ok;
	QPixmap		pix_no;
	QPixmap		pix_unknown;


	drive_info*	drive;
	char*	device;
	ScanThread*	thread;
	ScanTimer*	thread_time;
	QListViewItem*	sessions[255];
	int		session;
	QListViewItem*	tracks[255];
	int		track;

	plextor_ext_cx* px_ecx;
	int		ext_cx_active;

// *********** For results saving...
	QFileDialog	file_dialog;
	QImage*		logo;
	QImage*		result_rd;
	QImage*		result_cx;
	QImage*		result_jb;
	QImage*		result_ft;
	QImage*		result_ta;
	QString		logo_name;
	QString		png_name_rd;
	QString		png_name_cx;
	QString		png_name_BLER;
	QString		png_name_E11;
	QString		png_name_E21;
	QString		png_name_E31;
	QString		png_name_E12;
	QString		png_name_E22;
	QString		png_name_E32;
	QString		png_name_jb;
	QString		png_name_ft;
	QString		png_name_ta;
	QString		full_name_rd;
	QString		full_name_cx;
	QString		full_name_BLER;
	QString		full_name_E11;
	QString		full_name_E21;
	QString		full_name_E31;
	QString		full_name_E12;
	QString		full_name_E22;
	QString		full_name_E32;
	QString		full_name_jb;
	QString		full_name_ft;
	QString		full_name_ta;

	void		generate_result_html_hgrid(FILE *html);
	void		generate_result_html_ex_tbl1(FILE *html);
	void		generate_result_html_ex_tbl2(FILE *html);
	void		generate_result_html_ex_tbl3(FILE *html);
	void		generate_result_html(QString res_name, int tests);
	void		fill_res_rd();
	void		fill_res_cx();
	void		fill_res_cx_ext(int ext);
	void		fill_res_jb();
	void		fill_res_ft();
	void		fill_res_ta();
	void		fill_res_rd_grid();
	void		fill_res_cx_grid();
	void		fill_res_cx_ext_grid(int ext);
	void		fill_res_jb_grid();
	void		fill_res_ft_grid();
	void		fill_res_ta_grid(int layer, int zone);
	int		res_cap;

	void		stateCol_reset();
	void		stateCol_toggle();
	int		stateCol;
// ***************
	char	drvtbl[_devcnt][32];
	int 	speedidx, devtype, drvcnt, drvidx;
	int	grecn;

	int	c1pie_total, c2pif_total, cu_total;
	int	c1pie_max,   c2pif_max,   cu_max;
	float	c1pie_avg,   c2pif_avg,   cu_avg;
	float	j_min, j_max, j_avg;
	float	b_min, b_max, b_avg;
	int	TA_cur, TA_new, TA_layer, TA_zone;
	int	silent;

	int	last_cd_scan_speed, last_dvd_scan_speed;
	watcher_thread*	watcher;
protected:


protected slots:

};
#endif
