/***************************************************************************
                          configtable.cpp  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "configtable.h"
#include "qsstvglobal.h"
#include "../config.h"

sConfigEntry configTable[]=
{
  {"RXSamplingRate"    ,"8000"       ,FLOAT    ,0  ,"Receiver SamplingRate"       ,(void *)&fRXsamplingrate},
  {"TXSamplingRate"    ,"8000"       ,FLOAT    ,0  ,"Transmit SamplingRate"       ,(void *)&fTXsamplingrate},
  {"DefaultTxMode"     ,"M1"         ,STRING   ,1  ,"TX Mode"                     ,0},
  {"UseVisCode"        ,"1"          ,BOOL     ,1  ,"Use Vis Code"                ,(void *)&buseVIS},
  {"ImageTxDir"        ,""           ,STRING   ,1  ,"TX Image Directory"          ,0},
  {"ImageRxDir"        ,""           ,STRING   ,1  ,"RX Image Directory"          ,0},
  {"SoundDir"          ,""           ,STRING   ,1  ,"Sound Directory"             ,0},
  {"Thumbnailr1c1"     ,""           ,STRING   ,1  ,"Thumbnail 1"                 ,0},
  {"Thumbnailr1c2"     ,""           ,STRING   ,1  ,"Thumbnail 2"                 ,0},
  {"Thumbnailr1c3"     ,""           ,STRING   ,1  ,"Thumbnail 3"                 ,0},
  {"Thumbnailr1c4"     ,""           ,STRING   ,1  ,"Thumbnail 4"                 ,0},
  {"Thumbnailr1c5"     ,""           ,STRING   ,1  ,"Thumbnail 5"                 ,0},
  {"Thumbnailr1c6"     ,""           ,STRING   ,1  ,"Thumbnail 6"                 ,0},
  {"ImageFormat"       ,"png"        ,STRING   ,1  ,"Image format"                ,0},
  {"DefaultFilter"     ,"3"          ,INT      ,1  ,"Default receiver filter"     ,(void *)&idefaultFilter},
  {"DefaultPostFilter" ,"3"          ,INT      ,1  ,"Default receiver postfilter" ,(void *)&idefaultPostFilter},
  {"Banner"            ,"1"          ,BOOL     ,1  ,"Default Banner"              ,(void *)&buseBanner},
  {"Bannerimage1"      ,""           ,STRING   ,1  ,"Banner 1"                    ,0},
  {"Bannerimage2"      ,""           ,STRING   ,1  ,"Banner 2"                    ,0},
  {"Bannerimage3"      ,""           ,STRING   ,1  ,"Banner 3"                    ,0},
  {"Bannerimage4"      ,""           ,STRING   ,1  ,"Banner 4"                    ,0},
  {"Repeaterimage1"    ,""           ,STRING   ,1  ,"Repeater image 1"            ,0},
  {"Repeaterimage2"    ,""           ,STRING   ,1  ,"Repeater image 2"            ,0},
  {"Repeaterimage3"    ,""           ,STRING   ,1  ,"Repeater image 3"            ,0},
  {"Repeaterimage4"    ,""           ,STRING   ,1  ,"Repeater image 4"            ,0},
  {"RepeaterMode"      ,"M1"         ,STRING   ,1  ,"Repeater TX Mode"            ,0},
  {"RepeaterAckText"   ,"K"         ,STRING   ,1  ,"Repeater ACK (CW)"           ,0},
  {"RepeaterIDText"    ,"Repeater "   ,STRING   ,1  ,"Repeater Identification"     ,0},
  {"RepeaterImageInterval" ,"5"      ,INT      ,1  ,"Image interval (min)"        ,(void *)&irepImInterval},
  {"Timestamp"         ,"1"          ,BOOL     ,1  ,"Add Timestamp"               ,(void *)&btimestamp},
  {"UTC"               ,"1"          ,BOOL     ,1  ,"Timestamp in UTC"            ,(void *)&bUTC},
  {"Audiodev"          ,"/dev/dsp"   ,STRING   ,1  ,"Audio device"                ,0},
  {"Comdev"            ,"/dev/ttyS1" ,STRING   ,1  ,"Comport device"              ,0},
  {"Autosave"          ,"1"          ,BOOL     ,1  ,"Autosave images"             ,(void *)&bautoSave},
  {"CW"                ,"0"          ,BOOL     ,1  ,"CW at the end of TX"         ,(void *)&bCW},
  {"VOX"               ,"0"          ,BOOL     ,1  ,"Extra VOX delay in TX"       ,(void *)&bVOX},
  {"DX"                ,"0"          ,BOOL     ,1  ,"No auto resync"              ,(void *)&bDX},
  {"AutoErase"         ,"1"          ,BOOL     ,1  ,"Erase old image"             ,(void *)&bautoErase},
  {"syncSensitivity"   ,"1"					 ,INT      ,1  ,"Sync detection sensitivity"  ,(void *)&syncDetectSensitivity},
  {"modeSSTVFAXRX"   	 ,"0"					 ,INT      ,1  ,"Mode SSTV or FAX RX at startup" ,(void *)&modeSSTVFAXRX},
  {"modeSSTVFAXTX" 		 ,"0"					 ,INT      ,1  ,"Mode SSTV or FAX TX at startup" ,(void *)&modeSSTVFAXTX},
	{"faxType"           ,"0"          ,INT      ,1  ,"Fax type in menu"   					,(void *)&faxType},
	{"faxName1"          ,"Fax1"       ,STRING   ,1  ,"Fax Predefined 1"  					,0},
	{"lpm1"              ,"120"        ,INT      ,1  ,"Fax 1 lpm"          					,(void *)&faxlpm1},
	{"ioc1"              ,"288"        ,INT      ,1  ,"Fax 1 ioc"  				        	,(void *)&faxioc1},
	{"faxColors1"        ,"8"          ,INT      ,1  ,"Fax 1 colors"  				      ,(void *)&faxColors1},
	{"faxLines1"         ,"800"        ,INT      ,1  ,"Fax 1 lines"  				      	,(void *)&faxLines1},
	{"faxInvPol1"        ,"0"          ,BOOL     ,1  ,"FAX 1 Inverse Polarity"      ,(void *)&faxInvp1},
  {"faxName2"          ,"Fax2"       ,STRING   ,1  ,"Fax Predefined 2"  					,0},
	{"lpm2"              ,"120"        ,INT      ,1  ,"Fax 2 lpm"          					,(void *)&faxlpm2},
	{"ioc2"              ,"288"        ,INT      ,1  ,"Fax 2 ioc"  				        	,(void *)&faxioc2},
	{"faxColors2"        ,"8"          ,INT      ,1  ,"Fax 2 colors"  				      ,(void *)&faxColors2},
	{"faxLines2"         ,"800"        ,INT      ,1  ,"Fax 2 lines"  				      	,(void *)&faxLines2},
	{"faxInvPol2"        ,"0"          ,BOOL     ,1  ,"FAX 2 Inverse Polarity"      ,(void *)&faxInvp2},
	{"faxName3"          ,"Fax3"       ,STRING   ,1  ,"Fax Predefined 3"  					,0},
	{"lpm3"              ,"120"        ,INT      ,1  ,"Fax 3 lpm"          					,(void *)&faxlpm3},
	{"ioc3"              ,"288"        ,INT      ,1  ,"Fax 3 ioc"  				        	,(void *)&faxioc3},
	{"faxColors3"        ,"8"          ,INT      ,1  ,"Fax 3 colors"  				      ,(void *)&faxColors3},
	{"faxLines3"         ,"800"        ,INT      ,1  ,"Fax 3 lines"  				      	,(void *)&faxLines3},
	{"faxInvPol3"        ,"0"          ,BOOL     ,1  ,"FAX 3 Inverse Polarity"      ,(void *)&faxInvp3},
	{"faxName4"          ,"Fax4"       ,STRING   ,1  ,"Fax Predefined 4"  					,0},
	{"lpm4"              ,"120"        ,INT      ,1  ,"Fax 4 lpm"          					,(void *)&faxlpm4},
	{"ioc4"              ,"288"        ,INT      ,1  ,"Fax 4 ioc"  				        	,(void *)&faxioc4},
	{"faxColors4"        ,"8"          ,INT      ,1  ,"Fax 4 colors"  				      ,(void *)&faxColors4},
	{"faxLines4"         ,"800"        ,INT      ,1  ,"Fax 4 lines"  				      	,(void *)&faxLines4},
	{"faxInvPol4"        ,"0"          ,BOOL     ,1  ,"FAX 4 Inverse Polarity"      ,(void *)&faxInvp4},
  {"CWTone"            ,"1200"       ,INT      ,1  ,"CW tone in Hz"               ,(void *)&iCWHz},
  {"CWWPM"             ,"12"         ,INT      ,1  ,"CW words per minute"         ,(void *)&iCWWPM},
  {"CWText"            ,"qsstv"      ,STRING   ,1  ,"CW text to send"             ,0},
  {"bannerNumber"      ,"0"          ,INT      ,1  ,"selected banner"             ,(void *)&ibannerNumber },
  {"Repeater"          ,"0"          ,BOOL     ,1  ,"Select repeater"             ,(void *)&brepeater},
  {"FTP"               ,"0"          ,BOOL     ,1  ,"Enable FTP"                  ,(void *)&bftp},
  {"FTPHost"           ,""           ,STRING   ,1  ,"Host Address"                ,0},
  {"FTPRemDirectory"   ,""           ,STRING   ,1  ,"Remote directory"            ,0},
  {"FTPFilename"       ,""           ,STRING   ,1  ,"Fixed Filename"              ,0},
  {"FTPImageFormat"    ,"jpg"        ,STRING   ,1  ,"FTP Image format"            ,0},
  {"FTPUser"           ,"anonymous"  ,STRING   ,1  ,"FTP user login name"         ,0},
  {"FTPPassword"       ,"user@net"   ,STRING   ,1  ,"FTP password"                ,0},
  {"FTPPort"           ,"21"         ,INT      ,1  ,"FTP port number"             ,(void *)&iftpPort},
  {"PathUserGuide" 		 ,"/usr/local/doc/" PACKAGE "/",STRING   ,1  ,"Path to he user guide",0},
	{"BorderColor" 		   ,"16777215"   ,INT      ,1  ,"tx border color"             ,(void *)&borderColor},
	{"PositionKeepAR"    ,"1"          ,INT      ,1  ,"tx keep aspect ratio"        ,(void *)&posKeepAR},
	{"TXposLeft"  		   ,"0"          ,INT      ,1  ,"tx horiz position"           ,(void *)&pLeft},
	{"TXposCenter"  	   ,"1"          ,INT      ,1  ,"tx horiz position"           ,(void *)&pCenter},
	{"TXposRight"  		   ,"0"          ,INT      ,1  ,"tx horiz position"           ,(void *)&pRight},
	{"TXposTop"     	   ,"0"          ,INT      ,1  ,"tx vert position"            ,(void *)&pTop},
	{"TXposMiddle"       ,"1"          ,INT      ,1  ,"tx vert position"            ,(void *)&pMiddle},
	{"TXposBottom"  	   ,"0"          ,INT      ,1  ,"tx vert position"            ,(void *)&pBottom},
	{"TXposScaled"       ,"0"          ,INT      ,1  ,"tx scaling"			            ,(void *)&pScaled},
	{"ZoomScale"         ,"3"          ,INT      ,1  ,"zoom scaling"			          ,(void *)&zoomScale},
	{"ZoomWidth"         ,"640"        ,INT      ,1  ,"zoom width"		   	          ,(void *)&zoomWidth},
	{"ZoomHeight"        ,"480"        ,INT      ,1  ,"zoom height"	     	          ,(void *)&zoomHeight},
	{ 0                  ,0            ,STRING   ,0  , 0                            ,0}
};


void registerOptions()
{
  int i=0;
  while (configTable[i].name!=0)
    {
      configFile.registerOption(configTable[i].name,configTable[i].initialValue);
      i++;
    }
  configFile.readFile("qsstv.conf"); // readback config
  i=0;
  while (configTable[i].name!=0)
    {
      switch(configTable[i].type)
				{
				case FLOAT:
				   configFile.readOption(configTable[i].name,*(float *)configTable[i].variable);
				break;
				case BOOL:
				  configFile.readOption(configTable[i].name,*(bool *)configTable[i].variable);
				  break;
				case INT:
				  configFile.readOption(configTable[i].name,*(int *)configTable[i].variable);
				  break;
				default:
				break;
		 		}
   		i++;
    }
}

void saveActiveOptions()
{
	int i=0;
  while (configTable[i].name!=0)
    {
      switch(configTable[i].type)
				{
				case FLOAT:
				   configFile.setOption(configTable[i].name,*(float *)configTable[i].variable);
				break;
				case BOOL:
				  configFile.setOption(configTable[i].name,*(bool *)configTable[i].variable);
				  break;
				case INT:
				  configFile.setOption(configTable[i].name,*(int *)configTable[i].variable);
				  break;
				default:
				break;
		 		}
   		i++;
    }
   configFile.saveFile();
}
