/***************************************************************************
                          paint.h  -  description
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef PAINT_H
#define PAINT_H
#include <qmainwindow.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qcombobox.h>
#include <qtoolbutton.h>
#include "pstyle.h"
#include "ptext.h"
#include "imageframe.h"

#define NUMTOOLS 7

class imageFrame;

enum eselect {DARROW,DTEXT,DLINE,DRECT,DFRECT,DCIRCLE,DFCIRCLE,DIDLE,DSELECT,DIMAGE};

class subWindow : public imageFrame
{ 
  Q_OBJECT
public:
  subWindow(QWidget *parent=NULL,const char* name=NULL);
  ~subWindow();
  QPixmap tpm;
  QColor fgColor;
  QColor bgColor;
  QToolButton *buttonArray[NUMTOOLS];
  

public slots:
  void contentsMousePressEvent(QMouseEvent *event);
  void contentsMouseReleaseEvent(QMouseEvent *event);
  void contentsMouseMoveEvent(QMouseEvent *event);
  void arrow();
  void text();
  void line();
  void setStyle();
  void Rect();
  void fRect();
  void circle();
  void fcircle();
  void insertImage();

protected:
  QString fileName;
  eselect state;
  QPoint startPoint;
  QPoint endPoint;
  ptext *textBox;
  pstyle *styleBox;
  bool accepted;
  bool berase;
  void deselect();

};


class paint: public QMainWindow
{
    Q_OBJECT
public:
    paint(QWidget *parent,int x=320,int y=256);
    ~paint();

    void editImage(imageFrame *im);
    void closeEvent( QCloseEvent * );


public slots:  
  void finish();
  void abandon();
  void backgroundClicked();
  void foregroundClicked();	
  void aspect(bool b);
private:
    imageFrame *imageFramePtr;
    QToolBar *mainTools;
    QToolBar *drawTools;
    QToolBar *commandTools;
    QPushButton *foregroundSelect;
    QPushButton *backgroundSelect;
    subWindow *canvas;
};

#endif

































