/***************************************************************************
                          rxwindow.cpp  -  description
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rxwindow.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qwhatsthis.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qpaintdevicemetrics.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qtoolbar.h>
#include <ctype.h>
#include "sstvparam.h"
#include "ctext.h"
#include "filefunc.h"
#include "qsstvglobal.h"
#include "cpixmap.h"
#include "configdiag.h"
#include "dirdialog.h"
#include "slantadjust.h"
#include "fax.h"
#include "imageframe.h"
#include "helper.h"


#include "ledbar.h"

rxWindow::rxWindow(QWidget *p ,const char *n, WFlags f):QMainWindow( p,n,f)
{
  int i;
  printer = new QPrinter;
  
  mainTools = new QToolBar( this, "file operations" );
  filterTools = new QToolBar("",this,QMainWindow::Top,TRUE);
  faxTools = new QToolBar("",this,QMainWindow::Bottom,FALSE);
  QToolBar *sstvTools = new QToolBar("",this,QMainWindow::Left,TRUE);
  displayTools = new QToolBar("",this,QMainWindow::Bottom,TRUE);
  displayTools->setMinimumHeight(80);
  statusBar()->setSizeGripEnabled(FALSE);
  faxTools->hide();
  //  filterTools->hide();
  canvasX=canvasY=0;
  canvas = new imageFrame( this, "canvas" );
//  canvas->createImage(320,256,32);
//  setCanvasSize(320,256);
//  setCentralWidget(canvas);

  setToolBarsMovable ( FALSE);

  QToolButton * fileSave = new QToolButton( *fileSaveIcon, "Save File", 0,
					    this, SLOT(slotSave()),
					    mainTools, "save file" );
  
  QToolButton * filePrint = new QToolButton( *filePrintIcon, "Print File", 0,
					     this, SLOT(slotPrint()),
					     mainTools, "print file" );
  
  mainTools->addSeparator(); 

  QToolButton * startrx = new QToolButton( *startIcon, "Start Rx", 0,
					   this, SLOT(slotStart()),
					   mainTools, "start receive" ); 
  
  QToolButton * stoprx = new QToolButton( *stopIcon, "Stop Rx", 0,
					  this, SLOT(slotStop()),
					  mainTools, "stop receive" );
  
  QToolButton * toprx = new QToolButton( *topIcon, "Top Rx", 0,
					 this, SLOT(slotTop()),
					 mainTools, "go to top" );
  
  QToolButton * eraserx = new QToolButton( *eraserIcon, "Erase", 0,
					   this, SLOT(slotErase()),
					   mainTools, "erase window" );
  
  resyncrx = new QToolButton( *resyncIcon, "Resync", 0,
					    this, SLOT(slotResync()),
					    mainTools, "resync signal" );
  
  QToolButton * zoomrx = new QToolButton( *zoomIcon, "Zoom", 0,
					   this, SLOT(slotZoom()),
					   mainTools, "zoom signal" );
  QToolButton * browserrx = new QToolButton( *browserIcon, "Browse", 0,
					   this, SLOT(slotBrowserx()),
					   mainTools, "browse signal" );
	sstvfax=new QComboBox(FALSE,mainTools);
	sstvfax->insertItem("SSTV");
	sstvfax->insertItem("FAX");
	modeSSTVFAXRX=SSTV;
	connect( sstvfax, SIGNAL(activated(int)), SLOT(slotSSTVFAX(int)) );				
  QLabel *f=new QLabel("",mainTools);
  mainTools->setStretchableWidget (f ) ; 
  
  vu = new VUMeter(mainTools);
  vu->setBackgroundColor(green);
  vu->setMaximumSize(QSize(80,32767));
  vu->setMinimumSize(QSize(80,10));
  vu-> UseNeedle(FALSE);
  vu->setTotalSteps(30000);
  vu->setProgress(0);
  QColorGroup normal(
		     qRgb(0,0x0,0xff),    // foreground
		     qRgb(0x0,0x80,0), // background
		     qRgb(0xa0,0xa0,0xa0), // light
		     qRgb(0x40,0x40,0x20), // dark
		     qRgb(0xa0,0xa0,0x40),  // mid
		     qRgb(0x0,0x0,0x0),    //text
		     qRgb(0x0,0xff,0x0)   //base
		     );
  
  vu->setPalette( QPalette(normal,normal,normal) );
  

  QLabel *filterLabel=new QLabel("Filters  ",filterTools);
  filterLabel->setFixedWidth(60);
  filterLabel->setAlignment(AlignRight);
  QLabel *mainLabel=new QLabel("Main ",filterTools);
  mainLabel->setFixedWidth(40);
  mainLabel->setAlignment(AlignRight);
  filterMode=new QComboBox(FALSE,filterTools);
  for (i=0;i<NUMFILTERS;i++)
    {
      filterMode->insertItem(filterString[i]);
    }
  connect( filterMode, SIGNAL(highlighted(int)), SLOT(slotFilterChange(int)) );
  QLabel *postLabel=new QLabel("Post ",filterTools);
  postLabel->setFixedWidth(40);
  postLabel->setAlignment(AlignRight);
  postFilterMode=new QComboBox(FALSE,filterTools);
  for (i=0;i<NUMPOSTFILTERS;i++)
    {
      postFilterMode->insertItem(postFilterString[i]);
    }
  connect( postFilterMode, SIGNAL(highlighted(int)), SLOT(slotPostFilterChange(int)) );
  QLabel *fils=new QLabel("",filterTools);
  filterTools->setStretchableWidget (fils ) ;
	
  VISButton=new QCheckBox("VIS",sstvTools);
  autosaveBtn=new QCheckBox("AutoSave",sstvTools);
  dxBtn=new QCheckBox("DX",sstvTools);
  sensitivityCBox=new QComboBox(FALSE,sstvTools);
  sensitivityCBox->insertItem("Low Sen");
  sensitivityCBox->insertItem("Medium Sen");
  sensitivityCBox->insertItem("High Sen");
  eraseBtn=new QCheckBox("AutoErase",sstvTools);
  repeaterBtn=new QCheckBox("Repeater",sstvTools);
  leds=new ledBar(sstvTools);
  leds->setRedLed(TRUE);
  connect(VISButton,SIGNAL(toggled(bool)),this,SLOT(slotVisButton(bool)));
  connect(autosaveBtn,SIGNAL(toggled(bool)),this,SLOT(slotAutosaveButton(bool)));
  connect(dxBtn,SIGNAL(toggled(bool)),this,SLOT(slotDXButton(bool)));
  connect(sensitivityCBox,SIGNAL(highlighted(int)),this,SLOT(slotSensitivity(int)));
  connect(eraseBtn,SIGNAL(toggled(bool)),this,SLOT(slotAutoEraseButton(bool)));
  connect(repeaterBtn,SIGNAL(toggled(bool)),rep,SLOT(slotRepeaterButton(bool)));

  sstvTools->addSeparator();

  QLabel *faxLabel=new QLabel("Fax  ",faxTools);
  faxLabel->setFixedWidth(60);
  faxLabel->setAlignment(AlignRight);
  faxTypeComboBox= new QComboBox(FALSE,faxTools);
  faxTypeComboBox->insertItem(configFile.readOption("faxName1"));
  faxTypeComboBox->insertItem(configFile.readOption("faxName2"));
  faxTypeComboBox->insertItem(configFile.readOption("faxName3"));
  faxTypeComboBox->insertItem(configFile.readOption("faxName4"));
  QLabel *lpmLabel=new QLabel("lpm  ",faxTools);
  lpmLabel->setFixedWidth(40);
  lpmLabel->setAlignment(AlignRight);
  lpmSpinBox= new QSpinBox(10,600,10,faxTools);

  QLabel *iocLabel=new QLabel("ioc  ",faxTools);
  iocLabel->setFixedWidth(40);
  iocLabel->setAlignment(AlignRight);
  iocSpinBox= new QSpinBox(100,1000,2,faxTools);

  QLabel *colorLabel=new QLabel("Colors ",faxTools);
  colorLabel->setFixedWidth(50);
  colorLabel->setAlignment(AlignRight);
  colorComboBox= new QComboBox(FALSE,faxTools);
  colorComboBox->insertItem("2");
  colorComboBox->insertItem("4");
  colorComboBox->insertItem("8");
  colorComboBox->insertItem("16");
  colorComboBox->insertItem("32");
  colorComboBox->insertItem("64");
  colorComboBox->insertItem("128");
  colorComboBox->insertItem("256");
  
  QLabel *linesLabel=new QLabel("Lines ",faxTools);
  linesLabel->setFixedWidth(50);
  linesLabel->setAlignment(AlignRight);
  linesSpinBox= new QSpinBox(100,1600,10,faxTools);

	invPolCheckBox= new QCheckBox("Inv. Pol",faxTools);
  QLabel *faxs=new QLabel("",faxTools);	

  faxTools->setStretchableWidget (faxs ) ;
	connect(faxTypeComboBox,SIGNAL(highlighted(int)),this,SLOT(slotFaxTypeChanged(int)));
	slotFaxTypeChanged(faxType); // call to setup lpm and ioc
  QLabel *fs=new QLabel("",sstvTools);
  sstvTools->setStretchableWidget (fs ) ;
 
//  specDisplay=new spectrumDisplay(displayTools);
//  specDisplay->setFrameStyle(QFrame::Panel | QFrame::Sunken);
//  specDisplay->setMinimumHeight(60);
// specDisplay->setBackgroundColor(gray);
//	specDisplay->setLineWidth( 4 );		
		fftDisplay=new fft(displayTools);
		fftDisplay->setFrameStyle(QFrame::Panel | QFrame::Sunken);
//		fftDisplay->setMinimumHeight(60);
		fftDisplay->setFixedSize(FFTWIDTH,FFTHEIGHT);
		fftDisplay->setBackgroundColor(gray);
		fftDisplay->setLineWidth( 4 );

  syncDisplay=new syncroDisplay(displayTools);
  syncDisplay->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  syncDisplay->setMinimumHeight(60);
  syncDisplay->setMinimumWidth(220);
  syncDisplay->setBackgroundColor(gray);
  syncDisplay->setLineWidth( 4 );
	QLabel *dspt=new QLabel("",displayTools);
  displayTools->setStretchableWidget (dspt ) ;
 // specDisplay->draw();

  (void)QWhatsThis::whatsThisButton( mainTools );

  addWT( fileSave, fileSaveText );
  addWT( filePrint, filePrintText);
  addWT( startrx, startText);
  addWT( stoprx, stopText);
  addWT( toprx, topText);
  addWT( eraserx, eraseText);
  addWT( resyncrx, resyncText);
  addWT( zoomrx, zoomText);
  addWT( canvas,baseText);
  addWT( syncDisplay,syncText);
  addWT( VISButton,visText);
  addWT( vu,volumeText);
  addWT( autosaveBtn,autosaveText);
  addWT( browserrx,browserText);
  addWT( eraseBtn,autoEraseText);
  addWT( dxBtn,dxText);
  addWT( filterMode,selectFilterText);
	addWT( postFilterMode,postfilterText);
	addWT( repeaterBtn,repeaterText);
	addWT( sensitivityCBox,sensitivityText);
	addWT( sstvfax,sstvfaxText);

 
  QPopupMenu * file = new QPopupMenu();
  menuBar()->insertItem( "&File", file );
  file->insertItem( *fileSaveIcon, "Save", this, SLOT(slotSave()), CTRL+Key_S );
  file->insertSeparator();
  file->insertItem( *filePrintIcon, "Print", this, SLOT(slotPrint()), CTRL+Key_P );
  file->insertSeparator();
  file->insertItem( "Quit", qApp, SLOT(quit()), CTRL+Key_Q );
  
  QPopupMenu *options = new QPopupMenu();
  menuBar()->insertItem( "&Options", options );
  options->insertItem( "Configure", this, SLOT(slotConfig()), CTRL+Key_C );
  options->insertItem( "Slant Adjust", this, SLOT(slotAdjustSlant()), CTRL+Key_L );
  
#ifdef  DEBUGQSSTV
  QPopupMenu *debug = new QPopupMenu();
  menuBar()->insertItem( "&Debug", debug );
  debug->insertItem( "Dump", this, SLOT(slotDump()), CTRL+Key_D );
  debug->insertItem( "Plot", this, SLOT(slotPlot()), CTRL+Key_K );
  debug->insertItem( "Record", this, SLOT(slotRecord()), CTRL+Key_R );
#endif

  QPopupMenu *help = new QPopupMenu();
  menuBar()->insertItem( "&Help", help );
	help->insertItem( "QSSTV &User Guide",this,SLOT(slotUserGuide()),CTRL+Key_U);
  help->insertItem( "&About QSSTV", this, SLOT(slotAboutQSSTV()), CTRL+Key_A);
  help->insertItem( "A&bout Qt", this, SLOT(slotAboutQt()), CTRL+Key_B);
  permText=new QLabel(statusBar());
  permText->setText("Initialized");
  permText->setFixedSize(200,25);
  statusBar()->addWidget(permText,0,TRUE);

	QToolTip::add( sstvfax, "SSTV or FAX selection" );
	QToolTip::add( postFilterMode, "Select a postfilter" );
	QToolTip::add( sensitivityCBox, "Sync detect sensitivity" );
  QToolTip::add(VISButton, "Wait for VIS detection" );
  QToolTip::add(vu, "Volume indicator" );
  QToolTip::add(autosaveBtn, "Autosave received images" );
  QToolTip::add(dxBtn, "No resync under noisy conditions" );
  QToolTip::add(eraseBtn, "Erase window when receiving new image" );
  QToolTip::add(filterMode, "Select a receiver filter" );
	QToolTip::add(repeaterBtn, "Enable repeater" );
  buildLayoutSSTV();
  erase();
}

rxWindow::~rxWindow()
{
		delete leds;
    delete printer;
}



void rxWindow::buildLayoutSSTV()
{
	faxTools->setEnabled(FALSE);
	VISButton->setEnabled(TRUE);
	dxBtn->setEnabled(TRUE);
	sensitivityCBox->setEnabled(TRUE);
	repeaterBtn->setEnabled(TRUE);
	resyncrx->setEnabled(TRUE);
	modeSSTVFAXRX=SSTV;
	faxTools->hide();
//	setCanvasSize(340,260);
//	delete canvas; //regenerate layout
//	canvas = new imageFrame( this, "canvas");
	canvas->createImage(sstvparam.numberOfPixels,sstvparam.numberOfLines,32,sstvparam.numberOfPixels,sstvparam.numberOfLines);
	setCanvasSize(340,sstvparam.numberOfLines+220);
	setCentralWidget(canvas);
}

void rxWindow::buildLayoutFAX(int width,int height)
{
	faxTools->setEnabled(TRUE);
	VISButton->setEnabled(FALSE);
	dxBtn->setEnabled(FALSE);
	sensitivityCBox->setEnabled(FALSE);
	repeaterBtn->setEnabled(FALSE);
	resyncrx->setEnabled(FALSE);
	modeSSTVFAXRX=FAX;
//	delete canvas; //regenerate layout
	faxTools->show();
	filterTools->show();
//	canvas = new imageFrame( this, "canvas");
	canvas->createImage(width,height,32,600,480);
	setCanvasSize(600,720);
	setCentralWidget(canvas);
}



void rxWindow::slotSave()
{
  QDir stemp;
  QFileInfo t;
  QFile tempout;
  stemp.setPath(configFile.readOption("ImageRxDir"));
  if(openForWrite(tempout,stemp,"*"))
    { 
      tempout.remove();
      t.setFile(tempout.name());
      changeExtension(t,configFile.readOption("ImageFormat"),FALSE);
      canvas->save(t.filePath());
    }  
}

void rxWindow::slotPrint()
{
  if ( printer->setup(this) )
    {
      
      QPixmap t;
      t=*(canvas->getImagePtr());
      QPainter paint( printer );
      paint.drawPixmap(30,30,t);
    }
}



void rxWindow::slotAutosaveButton(bool b)
{
  bautoSave=b;
}

void rxWindow::slotDXButton(bool b)
{
  bDX=b;
}

void rxWindow::slotAutoEraseButton(bool b)
{
  bautoErase=b;
}

void rxWindow::slotSensitivity(int s)
{
	syncDetectSensitivity=s;
}


void rxWindow::setCanvasSize(int x,int y)
{
	if((x!=canvasX)||(y!=canvasY))
		{
  		setFixedSize(x,y);
  		canvasX=x;
  		canvasY=y;
  	}
}


void rxWindow::slotSSTVFAX(int i)
{
	modeSSTVFAXRX=i;
}


void rxWindow::slotErase()
{
  canvas->imageFill(ERASECOLOR);
}


void rxWindow::slotZoom()
{
  canvas->zoom();
}

void rxWindow::slotFaxTypeChanged(int i)
{
	faxType=i;
	if(i==0)
		{
			lpmSpinBox->setValue(faxlpm1);
			iocSpinBox->setValue(faxioc1);
			colorComboBox->setCurrentItem(faxColors1);
			linesSpinBox->setValue(faxLines1);
			invPolCheckBox->setChecked(faxInvp1);
		}
	else if(i==1)
		{
			lpmSpinBox->setValue(faxlpm2);
			iocSpinBox->setValue(faxioc2);
			colorComboBox->setCurrentItem(faxColors2);
			linesSpinBox->setValue(faxLines2);
			invPolCheckBox->setChecked(faxInvp2);
		}
	else if(i==2)		
		{
			lpmSpinBox->setValue(faxlpm3);
			iocSpinBox->setValue(faxioc3);
			colorComboBox->setCurrentItem(faxColors3);
			linesSpinBox->setValue(faxLines3);
			invPolCheckBox->setChecked(faxInvp3);
		}
	else
		{
			lpmSpinBox->setValue(faxlpm4);
			iocSpinBox->setValue(faxioc4);
			colorComboBox->setCurrentItem(faxColors4);
			linesSpinBox->setValue(faxLines4);
			invPolCheckBox->setChecked(faxInvp4);
		}
		
}

void rxWindow::slotConfig()
{
  configDialog diag(this,"tab",TRUE);
  if(diag.exec())
    {
      diag.update();
    }
}



void rxWindow::slotAdjustSlant()
{
  slantAdjust sa(this);
  sa.transferImage(canvas->getPixmapPtr());
  if(sa.exec())
    {
      foffsetRX=fRXsamplingrate-(float)isamplingrate;
      configFile.setOption("OffsetRX",foffsetRX);
      configFile.setOption("SamplingRate",(int &)isamplingrate);
    }
}


void rxWindow::slotAboutQSSTV()
{
  char tempstr[256];
  tempstr[0]=0;
  strcat(tempstr,"QSSTV");
  strcat(tempstr," version: ");
  strcat(tempstr,VERSION);
  strcat(tempstr,"\nCompiled on: ");
  strcat(tempstr,__DATE__);
  QMessageBox::about( this,PACKAGE,tempstr);
}

void rxWindow::slotAboutQt()
{
 QMessageBox::aboutQt( this, "QT from Toll" );
}

void rxWindow::slotUserGuide()
{
	QString home=QString(configFile.readOption("PathUserGuide"))+"index.html";
	QFileInfo finfo(home);
	if (finfo.isReadable())
		{
			HelpWindow *help = new HelpWindow(home, ".", 0, "help viewer");	
 			if ( QApplication::desktop()->width() > 400
	 				&& QApplication::desktop()->height() > 500 )
				{
					help->show();
				}
			else
				{
					help->showMaximized();
				}
		}
	else
		{
	QMessageBox::warning(this,"User Guide file locations",
                      "the file:\n" + home + "\ncould not be opened.\n"
                      +"Check if the file exist and you have read access"
                      +"The file could be in another location\n"
                      +"You can change this location in the configuration tables\n"
                      +"Menu->Options->Configuration");		
		}
}


void rxWindow::slotBrowserx()
{
  dirDialog dd(0,0,TRUE);
  dd.openFileName(configFile.readOption("ImageRxDir"));
}
























