#ifndef SYNCPROCESSOR_H
#define SYNCPROCESSOR_H
#include "qsstvdefs.h"
#include "dsp/filter.h"
#include "sstvparam.h"

#define SYNCARRAYLENGTH 512
#define SYNCDEVIATION 0.008

struct ssyncArray
{
  ssyncArray()
  {
    init();
  }
  void init()
  {
    start=end=length=width=0;
    retrace=false;
    keep=false;
    inUse=false;
    lineNumber=0;
    spurious=0;
  }
  unsigned int start;
  unsigned int end;
  unsigned int width;
  unsigned int length;
  unsigned int lineNumber;
  unsigned int spurious;
  DSPFLOAT freq;
  DSPFLOAT maxVol;
  bool retrace;
  bool keep;
  bool inUse;
};

struct smodeArray
{
  void clear()
  {
    match=0;
    lineNumber=0;
    consecutiveSyncs=0;
    firstSyncIndex=0;
    ratio=0;
  }
  unsigned int match;
  unsigned int lineNumber;
  unsigned int consecutiveSyncs;
  unsigned int firstSyncIndex;
  DSPFLOAT ratio;
};

struct ssenitivity
{
  DSPFLOAT switchOn;
  DSPFLOAT switchOff;
  DSPFLOAT minVolume;
  int syncLost;
};

struct sslantArray
{
  DSPFLOAT x;
  DSPFLOAT y;
};

#include <QObject>

class syncProcessor : public QObject
{
  enum esyncState {SYNCOFF,SYNCON,SYNCVALID};
  Q_OBJECT
public:
  explicit syncProcessor(QObject *parent = 0);
  void init();
  void setFilters(filter *rx,filter *sync) {rxFilter=rx; syncFilter=sync;}
  void process();
  int isInSync();
  bool hasRetrace(){return retraceDetected;}
  bool hasNewClock()
  {
    bool nc=newClock;
    newClock=false;
    return nc;
  }
  unsigned long getSyncPosition() { return syncPosition;}

  esstvMode getMode() {return  mode ;}
  //	DSPFLOAT *getSyncBufferPtr() {return syncBufferPtr;}
  DSPFLOAT getNewClock() {return modifiedClock;}
  void setOffset(unsigned int dataScopeOffset);
    int syncQuality;

  
signals:
  
public slots:
private:
  filter *rxFilter;
  filter *syncFilter;
  unsigned int sampleCounter;
  void extractSync();
  void incrementSyncArray();
  void modeDetect(bool atRetrace);
  void modeDetectByLine();
  void getMatchingSyncPulse(esstvMode idx);
  int  matchingSync(int start,unsigned int pos,DSPFLOAT syncWidth, bool shadow);
  void moveToTop(int index);
  void cleanupSyncArray(esstvMode modeIndex);
  void deleteSyncEntry(int index);
  void dumpSyncArray(bool withShadow,int start=0);
  int getSignalQuality();
  void trackSyncs(esstvMode selectedMode);
  void regression(DSPFLOAT &a,DSPFLOAT &b,int start, int end);
  bool slantAdjust();
  void restart();

  int *syncVolumePtr;
  int *rxVolumePtr;
  int *freqPtr;
  unsigned char syncStateBuffer[RXSTRIPE];
  esyncState syncState;
  ssyncArray syncArray[SYNCARRAYLENGTH];
  unsigned int syncArrayIndex;
  ssyncArray shadowSyncArray[SYNCARRAYLENGTH];
  unsigned int shadowSyncArrayIndex;
  smodeArray modeArray[AVT24];
  int signalQuality;

  unsigned int visCode;
  unsigned int visCounter;
  DSPFLOAT visAvg;
  unsigned int volumeOffCounter;

  esstvMode mode;

  DSPFLOAT modifiedClock;
  DSPFLOAT samplesPerLine;
  DSPFLOAT syncWd;
  unsigned int syncPosition;
  bool syncFound;
  unsigned int slantAdjustLine;
  sslantArray slantArray [SYNCARRAYLENGTH];
  bool newClock;
  DSPFLOAT syncDeviation;

  esstvMode idxStart;
  esstvMode idxEnd;
  unsigned int xOffset;

  unsigned int lostLines;
  bool retraceDetected;
};

#endif // SYNCPROCESSOR_H
