#include "qppdoptionitem.h"
#include "bool_on.xpm"
#include "bool_off.xpm"
#include "list.xpm"
#include "icons.h"

#include <qpainter.h>
#include <qapplication.h>

QPPDOptionItem::QPPDOptionItem(global_ppd_file_t *ppd, ppd_option_t *option, QListViewItem *parent, bool changeable)
	: QPPDBaseItem(ppd,parent)
{
	type_ = Regular;
	option_ = option;
	const char	**xpm = getOptionXPMString(option_->keyword);
	setPixmap(0,(xpm ? QPixmap(xpm) : QPixmap(list)));
	currentchoice_ = 0;
	changeable_ = changeable;
        ppd_choice_t	*defchoice_(0);
	for (int i=0;i<option_->num_choices;i++)
	{
		ppd_choice_t	*ch = option_->choices+i;
		if (ch->marked) currentchoice_ = ch;
		if (strcmp(ch->choice,option_->defchoice) == 0) defchoice_ = ch;
	}
	setCurrentChoice((currentchoice_ ? currentchoice_ : defchoice_));
	updateText();
}

QPPDOptionItem::~QPPDOptionItem()
{
}

void QPPDOptionItem::setCurrentChoice(int index)
{
	if (index >= 0 && index < option_->num_choices)
		setCurrentChoice(option_->choices+index);
	else
		setCurrentChoice(0);
}

void QPPDOptionItem::setCurrentChoice(ppd_choice_t *ch)
{
	currentchoice_ = ch;
	if (option_->ui == PPD_UI_BOOLEAN)
	{
		if (!currentchoice_) setPixmap(0,QPixmap());
		else if (strcmp(currentchoice_->choice,"True") == 0) setPixmap(0,QPixmap(bool_on));
		else setPixmap(0,QPixmap(bool_off));
	}
	if (currentchoice_ && ppd_) globalPpdMarkOption(ppd_,option_->keyword,currentchoice_->choice);
	updateText();
}

void QPPDOptionItem::updateText()
{
	QString	txt;
	txt.sprintf("%s: <%s>",option_->text,(currentchoice_ ? currentchoice_->text : QObject::tr("Undefined").data()));
	setText(0,txt.data());
}

void QPPDOptionItem::markChoices(global_ppd_file_t *ppd)
{
	if (currentchoice_)
		globalPpdMarkOption(ppd,option_->keyword,currentchoice_->choice);
}

void QPPDOptionItem::updateChoices(global_ppd_file_t *ppd)
{
	ppd_choice_t	*ch = ppdFindMarkedChoice(ppd->ppd,option_->keyword);
	setCurrentChoice(ch);
}

void QPPDOptionItem::getCupsOptions(int& num_options, cups_option_t **options, bool incldef)
{
	if (currentchoice_ && (incldef || strcmp(currentchoice_->choice,option_->defchoice) != 0)) {
		num_options = cupsAddOption(option_->keyword,currentchoice_->choice,num_options,options);
	}
}

void QPPDOptionItem::paintText(QPainter *p, const QColorGroup& cg, int r)
{
	QString	txt;
	QFontMetrics	fm(p->fontMetrics());

	// first part (normal color)
	txt.sprintf("%s: <",option_->text);
	p->setPen(isSelected() ? white : cg.text());
	p->drawText(r,0,fm.width(txt.data()),height(),AlignLeft|AlignVCenter,txt.data());
	r += fm.width(txt.data());
	// second part (option color)
	if (currentchoice_)
	{
		txt = currentchoice_->text;
		if (!isSelected()) p->setPen((conflict_ ? red : darkGreen));
	}
	else
		txt = QObject::tr("Undefined");
	p->drawText(r,0,fm.width(txt.data()),height(),AlignLeft|AlignVCenter,txt.data());
	r += fm.width(txt.data());
	// last part (normal color)
	p->setPen(isSelected() ? white : cg.text());
	txt = ">";
	p->drawText(r,0,fm.width(txt.data()),height(),AlignLeft|AlignVCenter,txt.data());
}

void QPPDOptionItem::setupDict(QDict<QPPDBaseItem>& dict) const
{
	dict.insert(option_->keyword,this);
}

void QPPDOptionItem::updateConflict()
{
	if (option_->conflicted) setConflict(true);
}
