# Comment the following section if autodetection fails
unix:!mac {
    CCACHE = $$system(which ccache)
    !isEmpty(CCACHE) {
        message("using ccache")
        QMAKE_CXX = ccache g++
        QMAKE_CC = ccache gcc
    }

    PROGRAM_PREFIX  = $$(prefix)
    isEmpty( PROGRAM_PREFIX ) {
        PROGRAM_PREFIX = /usr/local
        message( "You can provide your own prefix." )
        message( "Example: prefix=\"/usr\" qmake-qt4" )
    }
    message( "QTScrobbler will be installed in $${PROGRAM_PREFIX}" )

    target.path = $${PROGRAM_PREFIX}/bin
    desktop.path = $${PROGRAM_PREFIX}/share/applications
    desktop.path = $${PROGRAM_PREFIX}/share/applications
    desktop.files = qtscrob.desktop
    desktopicon.path = $${PROGRAM_PREFIX}/share/icons/hicolor/32x32/apps
    desktopicon.files = resources/icons/qtscrob.png

    INSTALLS = target desktop desktopicon
}

CUSTOM_BUILD_FOLDERS = true

win32{
	win32-msvc* {
		# exclude MSVC - otherwise requires full rebuilds when changing between release/debug
		CUSTOM_BUILD_FOLDERS = false
	}
}

contains(CUSTOM_BUILD_FOLDERS, true) {
	OBJECTS_DIR = build/.o
	UI_DIR = build/.ui
	MOC_DIR	= build/.moc
	RCC_DIR	= build/.rcc
}

TEMPLATE = app
QT = gui core
LANGUAGE = C++
INCLUDEPATH += . src src/ui ../lib
CONFIG	+= qt x11
#debug messages on windows
#win32:debug:CONFIG += console

SOURCES	= src/main.cpp \
	src/qtscrob.cpp \
	src/settings.cpp \
	src/about.cpp \
	src/help.cpp \
	src/browsedirtree.cpp \
	src/progress.cpp \
	src/threadscrobble.cpp \
	src/console.cpp \
	../lib/md5.c \
	../lib/ConvertUTF.c \
	../lib/libscrobble.cpp


FORMS	= src/ui/settingsWin.ui \
	src/ui/aboutWin.ui \
	src/ui/browsedirtree.ui \
	src/ui/progressWin.ui

OPENEDFILES	= src/main.cpp \
	src/qtscrob.h \
	src/qtscrob.cpp

HEADERS	= src/qtscrob.h \
	src/settings.h \
	src/about.h \
	src/help.h \
	src/browsedirtree.h \
	src/progress.h \
	src/console.h \
	../lib/md5.h \
	../lib/ConvertUTF.h \
	../lib/libscrobble.h 

TRANSLATIONS = translations/pl.ts \
	translations/de.ts

RESOURCES = qtscrob.qrc

#curl joy
win32{
    RC_FILE = qtscrob.rc

    # use the bundled version in a fixed, known location
    win32-msvc* {
        INCLUDEPATH += libcurl/include
        LIBS += -Llibcurl curllib.lib #/NODEFAULTLIB:"LIBCMT.lib"
        QMAKE_LFLAGS += /FORCE:MULTIPLE
    } else {
        # mingw
        !isEmpty(CURLCONF) {
            message("using curl-config")
            LIBS += $$system(curl-config --libs)
            INCLUDEPATH += $$system(curl-config --cflags)
        } else {
            INCLUDEPATH += libcurl/include
            LIBS += -lcurl -Llibcurl
        }
    }
} else {
    CURLCONF = $$system(which curl-config)
    !isEmpty(CURLCONF) {
        message("using curl-config")
        LIBS += $$system(curl-config --libs)
        INCLUDEPATH += $$system(curl-config --cflags)
    } else {
        LIBS += -lcurl
    }

}

#mtp joy
win32{
	win32-msvc* {
	    # Default location for Windows Media Format 11 SDK
		# Works on XP and Vista.  Only available as a 32 bit lib,
		# but the 32 bit compiled exe works fine on 64-bit windows.
		exists( c:/WMSDK/WMFSDK11/WMDM/lib/mssachlp.lib ) {
			message( "Found the WMFSDK - enabling MTP" )
		    DEFINES += HAVE_WMDM
		    INCLUDEPATH += "C:\WMSDK\WMFSDK11\WMDM\inc"
		    LIBS += -L"C:\WMSDK\WMFSDK11\WMDM\lib" mssachlp.lib
			SOURCES += ../lib/mtp-win32.cpp
		} else {
			message ( "The Windows Media Format 11 SDK was NOT found - MTP support will not be compiled" )
			message ( "It is available at: http://msdn.microsoft.com/en-us/windowsmedia/bb190309.aspx" )
		}
	}
} else {
    CONFIG += link_pkgconfig
    PKGCONFIG += libmtp
    SOURCES += ../lib/mtp-libmtp.cpp
	DEFINES += HAVE_LIBMTP
}

unix:mac{
    ICON = resources/icons/qtscrob.icns
# uncomment the following two lines if you have
# recompiled the QT toolkit for universal builds
# and wish to produce a universal binary
#    QMAKE_MAC_SDK=/Developer/SDKs/MacOSX10.4u.sdk
#    CONFIG+=x86 ppc
}
