
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Solvers1D.i,v 1.9 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_solver1d_i
#define quantlib_solver1d_i

%include Functions.i

// 1D Solver interface

%{
using QuantLib::Solver1D;
using QuantLib::Solvers1D::Bisection;
using QuantLib::Solvers1D::Brent;
using QuantLib::Solvers1D::FalsePosition;
using QuantLib::Solvers1D::Newton;
using QuantLib::Solvers1D::NewtonSafe;
using QuantLib::Solvers1D::Ridder;
using QuantLib::Solvers1D::Secant;
%}

class Solver1D {
  private:
    // abstract class - no constructor exported
    Solver1D();
  public:
    ~Solver1D();
    void setMaxEvaluations(int evaluations);
    void setLowBound(double lowBound);
    void setHiBound(double hiBound);
};

%addmethods Solver1D {
    double solve(PyObject* pyFunction, double xAccuracy, double guess,
        double step) {
            PyObjectiveFunction f(pyFunction);
            return self->solve(f, xAccuracy, guess, step);
    }
    double bracketedSolve(PyObject* pyFunction, double xAccuracy,
        double guess, double xMin, double xMax) {
            PyObjectiveFunction f(pyFunction);
            return self->solve(f, xAccuracy, guess, xMin, xMax);
    }
}


// Actual solvers

class Brent : public Solver1D {
  public:
    Brent();
    ~Brent();
};

class Bisection : public Solver1D {
  public:
    Bisection();
    ~Bisection();
};

class FalsePosition : public Solver1D {
  public:
    FalsePosition();
    ~FalsePosition();
};

class Newton : public Solver1D {
  public:
    Newton();
    ~Newton();
};

class NewtonSafe : public Solver1D {
  public:
    NewtonSafe();
    ~NewtonSafe();
};

class Ridder : public Solver1D {
  public:
    Ridder();
    ~Ridder();
};

class Secant : public Solver1D {
  public:
    Secant();
    ~Secant();
};


#endif
