
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Swap.i,v 1.22 2002/03/07 14:06:32 lballabio Exp $

#ifndef quantlib_swap_i
#define quantlib_swap_i

%include Instruments.i
%include TermStructures.i
%include CashFlows.i

%{
using QuantLib::Instruments::Swap;
using QuantLib::Instruments::SimpleSwap;
typedef Handle<Swap> SwapHandle;
typedef Handle<SimpleSwap> SimpleSwapHandle;
%}

// fake inheritance between handles
%name(Swap) class SwapHandle
: public InstrumentHandle {
  public:
    // constructor redefined below
    ~SwapHandle();
};

%addmethods SwapHandle {
    SwapHandle(CashFlowHandleVector firstLeg,
               CashFlowHandleVector secondLeg,
               TermStructureRelinkableHandle termStructure,
               String isinCode, String description) {
	        return new SwapHandle(
	            new Swap(firstLeg, secondLeg, termStructure,
	                isinCode, description));
    }
}



// fake inheritance between handles
%name(SimpleSwap) class SimpleSwapHandle
: public InstrumentHandle {
  public:
    // constructor redefined below
    ~SimpleSwapHandle();
};

%addmethods SimpleSwapHandle {
    SimpleSwapHandle(bool payFixedRate, Date startDate, int n, TimeUnit unit,
        Calendar calendar, RollingConvention rollingConvention,
        double nominal, int fixedFrequency, Rate fixedRate,
        bool fixedIsAdjusted, DayCounter fixedDayCount,
        int floatingFrequency, XiborHandle index, int indexFixingDays,
        Spread spread, TermStructureRelinkableHandle termStructure, 
        String isinCode, String description) {
            QL_REQUIRE(!index.isNull(), "null index given");
            Handle<Xibor> h = index;
            QL_REQUIRE(!h.isNull(), "index not of Libor type");
            return new SimpleSwapHandle(
                new SimpleSwap(payFixedRate, startDate, n, unit, calendar,
                    rollingConvention, nominal, fixedFrequency, fixedRate,
                    fixedIsAdjusted, fixedDayCount, floatingFrequency,
                    h, indexFixingDays, spread, termStructure, 
                    isinCode, description));
    }
    Rate fairRate() {
        return (*self)->fairRate();
    }
    double fixedLegBPS() {
        return (*self)->fixedLegBPS();
    }
    double floatingLegBPS() {
        return (*self)->floatingLegBPS();
    }
    Date maturity() {
        return (*self)->maturity();
    }
}


#endif
