
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: ql.i,v 1.29 2002/03/13 16:10:41 lballabio Exp $


%{
#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000300b1
    #error using an old version of QuantLib, please update
#endif

#if PY_VERSION_HEX < 0x02010000
    #error using an old version of Python, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig dependent useless warning

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

#endif

%}

%include Barrier.i
%include BlackInstruments.i
%include BoundaryConditions.i
%include Calendars.i
%include CashFlows.i
%include Currencies.i
%include Date.i
%include DayCounters.i
%include Distributions.i
%include Exercise.i
%include FdPricers.i
%include Functions.i
%include History.i
%include Indexes.i
%include Instruments.i
%include Interpolation.i
%include MarketElements.i
%include Matrix.i
%include MontecarloPricers.i
%include MontecarloTools.i
%include MultiPath.i
%include Null.i
%include Observer.i
%include Operators.i
%include Options.i
%include Path.i
%include PiecewiseFlatForward.i
%include Pricers.i
%include QLArray.i
%include RandomNumbers.i
%include RateHelpers.i
%include RiskStatistics.i
%include Scheduler.i
%include SegmentIntegrals.i
%include Solvers1D.i
%include Statistics.i
%include String.i
%include Swap.i
%include TermStructures.i
%include Types.i
%include Vectors.i
%include Volatility.i
