#!/usr/bin/python

"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.16 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/finite_difference_european.py,v $

import QuantLib
import unittest
import math

class FDEuropeanOptionTest(unittest.TestCase):
    def runTest(self):
        "Testing finite-difference European option pricer"
        under = 100
        strikeMin = 60
        rangeStrike = 100
        rangeRrate = 0.18
        rangeQrate = 0.02
        rangeVol = 1.2
        timeMin = 0.5
        rangeTime = 2

        tolerance = 8.42e-3
        maxError = 0
        L2err = 0

        totCases = 200
        rng = QuantLib.UniformRandomGenerator(56789012)
        for ite in range(totCases):
            strike = strikeMin + rangeStrike * rng.next().value
            Qrate =              rangeQrate * rng.next().value
            Rrate =              rangeRrate * rng.next().value
            vol =                rangeVol * rng.next().value
            resTime = timeMin +  rangeTime * rng.next().value
            for optType in ['Call', 'Put', 'Straddle']:
                anValue = QuantLib.EuropeanOption(
                           optType, under, strike, Qrate,
                           Rrate, resTime, vol).value()
                numValue = QuantLib.FdEuropean(
                           optType, under, strike, Qrate,
                           Rrate, resTime, vol, 100, 400).value()
                error = abs(anValue - numValue)
                if not (error <= tolerance):
                    self.fail("""
Option details: %(optType)s %(under)g %(strike)g %(Qrate)g %(Rrate)g %(resTime)g %(vol)g
    Error = %(error)12.2e
	                          """ % locals())


if __name__ == '__main__':
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(FDEuropeanOptionTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')

