#!/usr/bin/python

"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.11 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/segmentintegral.py,v $

import QuantLib
import unittest
import math

class SegmentIntegralTest(unittest.TestCase):
    def runTest(self):
        "Testing segment integral"
        tol = 1e-4
        integrate = QuantLib.SegmentIntegral(10000)

        i1 = integrate(lambda x: 1, 0, 1)
        i1_res = 1.0
        if not (abs(i1 - i1_res) <= tol):
            self.fail("""
integrate(lambda x: 1, 0, 1)
    calculated: %(i1)f
    expected  : %(i1_res)f
                      """ % locals())

        i2 = integrate(lambda x: x, 0, 1)
        i2_res = 0.5
        if not (abs(i2 - i2_res) <= tol):
            self.fail("""
integrate(lambda x: x, 0, 1)
    calculated: %(i2)f
    expected  : %(i2_res)f
                      """ % locals())

        i3 = integrate(lambda x: x*x, 0, 1)
        i3_res = 1.0/3.0
        if not (abs(i3 - i3_res) <= tol):
            self.fail("""
integrate(lambda x: x*x, 0, 1)
    calculated: %(i3)f
    expected  : %(i3_res)f
                      """ % locals())

        i4 = integrate(math.sin, 0, math.pi)
        i4_res = 2.0
        if not (abs(i4 - i4_res) <= tol):
            self.fail("""
integrate(math.sin, 0, math.pi)
    calculated: %(i4)f
    expected  : %(i4_res)f
                      """ % locals())

        i5 = integrate(math.cos, 0, math.pi)
        i5_res = 0.0
        if not (abs(i5 - i5_res) <= tol):
            self.fail("""
integrate(math.cos, 0, math.pi)
    calculated: %(i5)f
    expected  : %(i5_res)f
                      """ % locals())

        i6 = integrate(lambda x: math.exp(-x*x/2.0)/math.sqrt(2*math.pi), -10.0, 10.0)
        i6_res = 1.0
        if not (abs(i6 - i6_res) <= tol):
            self.fail("""
integrate(lambda x: math.exp(-x*x/2.0)/math.sqrt(2*math.pi), -10.0, 10.0)
    calculated: %(i6)f
    expected  : %(i6_res)f
                      """ % locals())


if __name__ == '__main__':
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(SegmentIntegralTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')

