

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Interpolation.i,v 1.8 2002/03/12 11:27:30 nando Exp $

#ifndef quantlib_interpolation_i
#define quantlib_interpolation_i

%include QLArray.i

%{
using QuantLib::Handle;
using QuantLib::Math::Interpolation;
using QuantLib::Math::LinearInterpolation;
using QuantLib::Math::CubicSpline;
using QuantLib::Array;
typedef Handle<Interpolation<Array::const_iterator, Array::const_iterator> >
	InterpolationHandle;
typedef Handle<LinearInterpolation<Array::const_iterator, Array::const_iterator> >
	LinearInterpolationHandle;
typedef Handle<CubicSpline<Array::const_iterator, Array::const_iterator> >
	CubicSplineInterpolationHandle;
%}

// export Handle<Interpolation>
%name(Interpolation) class InterpolationHandle {
  public:
	// no constructor - forbid explicit construction
	~InterpolationHandle();
};

// replicate the Interpolation interface
%addmethods InterpolationHandle {
    void crash() {}
	double __call__(double x) {
		return (**self)(x);
	}
};


// actual interpolations

%name(LinearInterpolation)
class LinearInterpolationHandle : public InterpolationHandle {
  public:
    // constructor redefined below
    ~LinearInterpolationHandle();
};

%addmethods LinearInterpolationHandle {
    void crash() {}
    LinearInterpolationHandle(const Array& x, const Array& y, bool allowExtrapolation) {
        return new LinearInterpolationHandle(
        new LinearInterpolation<Array::const_iterator,Array::const_iterator>(
            x.begin(),x.end(),y.begin(), allowExtrapolation));
    }
}

%name(CubicSpline)
class CubicSplineInterpolationHandle : public InterpolationHandle {
  public:
    // constructor redefined below
    ~CubicSplineInterpolationHandle();
};

%addmethods CubicSplineInterpolationHandle {
    void crash() {}
    CubicSplineInterpolationHandle(const Array& x, const Array& y, bool allowExtrapolation) {
        return new CubicSplineInterpolationHandle(
        new CubicSpline<Array::const_iterator,Array::const_iterator>(
            x.begin(),x.end(),y.begin(), allowExtrapolation));
    }
}


#endif
