
# $Id: makefile.mak,v 1.10 2002/03/21 17:03:16 nando Exp $

.autodepend
.silent

# Debug version
!ifdef DEBUG
    _D = _d
!endif

# Directories
INCLUDE_DIR    = ..\..
BCC_INCLUDE    = $(MAKEDIR)\..\include

# Object files
OBJS = \
    arithmeticapopathpricer.obj$(_D) \
    arithmeticasopathpricer.obj$(_D) \
    basketpathpricer.obj$(_D) \
    europeanpathpricer.obj$(_D) \
    everestpathpricer.obj$(_D) \
    geometricapopathpricer.obj$(_D) \
    geometricasopathpricer.obj$(_D) \
    getcovariance.obj$(_D) \
    himalayapathpricer.obj$(_D) \
	maxbasketpathpricer.obj$(_D) \
    pagodapathpricer.obj$(_D)

# Tools to be used
CC        = bcc32
TLIB      = tlib

# Options
CC_OPTS        = -vi- -q -c -tWM -n$(OUTPUT_DIR) \
    -w-8026 -w-8027 -w-8012 \
    -I$(INCLUDE_DIR) \
    -I$(BCC_INCLUDE)
!ifdef DEBUG
CC_OPTS = $(CC_OPTS) -v -DQL_DEBUG
!endif

TLIB_OPTS    = /P128
!ifdef DEBUG
TLIB_OPTS    = /P128
!endif

# Generic rules
.cpp.obj:
    $(CC) $(CC_OPTS) $<
.cpp.obj$(_D):
    $(CC) $(CC_OPTS) -o$@ $<

# Primary target:
# static library
MonteCarlo$(_D).lib:: $(OBJS)
    if exist MonteCarlo$(_D).lib     del MonteCarlo$(_D).lib
    $(TLIB) $(TLIB_OPTS) MonteCarlo$(_D).lib /a $(OBJS)


# Clean up
clean::
    if exist *.obj   del /q *.obj
    if exist *.lib   del /q *.lib

