/***************************************************************************
                          imagefilterdialog.cpp  -  description
                             -------------------
    begin                : Fri Jan 18 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "imagefilterdialog.h"
#include "quiteinsane/qxmlconfig.h"

#include <qcheckbox.h>
#include <qframe.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qvbox.h>
#include <qwhatsthis.h>

ImageFilterDialog::ImageFilterDialog(int preview_size,QImage* image,QWidget* parent)
                  :QDialog(parent,0,true)
{
  mpMiniImage = 0;
  mStopped = false;
  mPreviewSize = preview_size;
  mpOrigImage = image;
  mpControlsVBox = 0;
  initDialog();
  mpPreviewLabel->setMinimumSize(preview_size,preview_size);
  if(image)
    setImage(image);
}
ImageFilterDialog::~ImageFilterDialog()
{
}
/** No descriptions */
void ImageFilterDialog::initDialog()
{
  QWidget* dummy;
  mpMainGrid = new QGridLayout(this,5,3);
  mpMainGrid->setRowStretch(3,1);
  mpMainGrid->setMargin(5);
  mpMainGrid->setSpacing(3);
  //what's this
  QHBox* wthbox = new QHBox(this);
  dummy = new QWidget(wthbox);
  QToolButton* tb = QWhatsThis::whatsThisButton(wthbox);
  wthbox->setStretchFactor(dummy,1);
  mpMainGrid->addMultiCellWidget(wthbox,0,0,0,2);
  if(!xmlConfig->boolValue("ENABLE_WHATSTHIS_BUTTON"))
    tb->hide();
  //preview label
  QVBox* prevb = new QVBox(this);
  mpPreviewLabel = new QLabel(prevb);
  mpUpdateHBox = new QHBox(prevb);
  mpUpdateCheckBox = new QCheckBox(tr("Continous update"),mpUpdateHBox);
  mpUpdateButton = new QPushButton(tr("Update"),mpUpdateHBox);
  mpUpdateButton->setEnabled(false);
  mpUpdateCheckBox->setChecked(true);
  mpUpdateHBox->setStretchFactor(mpUpdateCheckBox,1);
  prevb->setStretchFactor(mpPreviewLabel,1);
  mpMainGrid->addMultiCellWidget(prevb,1,3,0,0);
  //vertical separator
  QFrame* sepv = new QFrame(this);
  sepv->setFrameStyle(QFrame::VLine|QFrame::Sunken);
  sepv->setLineWidth(2);
  mpMainGrid->addMultiCellWidget(sepv,1,3,1,1);
  //title
  mpTitleLabel = new QLabel(this);
  mpMainGrid->addWidget(mpTitleLabel,1,2);
  //horizontal separator
  QFrame* seph = new QFrame(this);
  seph->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  seph->setLineWidth(2);
  mpMainGrid->addWidget(seph,2,2);
  //Buttons
  mpButtonHb = new QHBox(this);
  mpOkButton = new QPushButton(tr("&OK"),mpButtonHb);
  dummy = new QWidget(mpButtonHb);
  QPushButton* cancelbutton = new QPushButton(tr("&Cancel"),mpButtonHb);
  mpButtonHb->setStretchFactor(dummy,1);
  mpMainGrid->addMultiCellWidget(mpButtonHb,4,4,0,2);
  connect(mpUpdateCheckBox,SIGNAL(toggled(bool)),this,SLOT(slotContinousUpdate(bool)));
  connect(mpUpdateButton,SIGNAL(clicked()),this,SLOT(slotUpdatePreview()));
  connect(mpOkButton,SIGNAL(clicked()),this,SLOT(accept()));
  connect(cancelbutton,SIGNAL(clicked()),this,SLOT(reject()));
  //controls VBox
  mpControlsVBox  = new QVBox(this);
  mpControlsVBox->setMargin(5);
  mpControlsVBox->setSpacing(6);
  mpMainGrid->addWidget(mpControlsVBox,3,2);

  mpMainGrid->activate();
}
/** No descriptions */
void ImageFilterDialog::setImage(QImage* image)
{
  double w,h;
  double d;
  mpOrigImage = image;
  w = double(mpOrigImage->width());
  h = double(mpOrigImage->height());
  if(w>h)
    d = double(mPreviewSize)/w;
  else
    d = double(mPreviewSize)/h;
  mpMiniImage = new QImage;
  *mpMiniImage = mpOrigImage->smoothScale(int(d*w),int(d*h));
  if(mpMiniImage->depth() != mpOrigImage->depth())
    *mpMiniImage = mpMiniImage->convertDepth(mpOrigImage->depth());
  slotUpdatePreview();
}
/** No descriptions */
void ImageFilterDialog::updatePreview()
{
  if(!mpUpdateCheckBox->isChecked())
    return;
  slotUpdatePreview();
}
/** No descriptions */
void ImageFilterDialog::slotUpdatePreview()
{
  if(!mpMiniImage)
    return;
  mPreviewImage = mpMiniImage->copy();
  if(!mpPreviewLabel)
    return;
  QPixmap pix;
  apply(&mPreviewImage,false);
  if((mPreviewImage.width() != mpMiniImage->width()) ||
     (mPreviewImage.height() != mpMiniImage->height()))
  {
    double w,h;
    double d;
    w = double(mPreviewImage.width());
    h = double(mPreviewImage.height());
    if(w>h)
      d = double(mPreviewSize)/w;
    else
      d = double(mPreviewSize)/h;
    mPreviewImage = mPreviewImage.smoothScale(int(d*w),int(d*h));
  }
  if(mPreviewImage.hasAlphaBuffer())
  {
    QImage alpha_image;
    alpha_image = mPreviewImage.copy();
    if(alpha_image.depth() < 32)
      alpha_image = alpha_image.convertDepth(32);
    alpha_image.setAlphaBuffer(false);
    QRgb rgb;
    QRgb rgb_b;
    QRgb rgb_l;
    QRgb rgb1 = QColor(gray).rgb();
    QRgb rgb2 = QColor(lightGray).rgb();
    int lcnt,xcnt,alpha,inv_alpha;
    bool b;
    b = false;
    lcnt = 0;
    xcnt = 0;
    rgb_b = rgb1;
    rgb_l = rgb1;
    for(int y=0;y<alpha_image.height();y++)
    {
      for(int x=0;x<alpha_image.width();x++)
      {
        rgb = mPreviewImage.pixel(x,y);
        inv_alpha = 255 - qAlpha(rgb);
        alpha = qAlpha(rgb);
        alpha_image.setPixel(x,y,
                     qRgb(qRed(rgb_b)*inv_alpha/255 + qRed(rgb)*alpha/255,
                          qGreen(rgb_b)*inv_alpha/255 + qGreen(rgb)*alpha/255,
                          qBlue(rgb_b)*inv_alpha/255 + qBlue(rgb)*alpha/255));
        ++xcnt;
        if(xcnt >= 20)
        {
          xcnt = 0;
          rgb_b = (rgb_b == rgb1) ? rgb2 : rgb1;
        }
      }
      ++lcnt;
      if(lcnt >= 20)
      {
        lcnt = 0;
        rgb_l = (rgb_l == rgb1) ? rgb2 : rgb1;
      }
      xcnt = 0;
      rgb_b = rgb_l;
    }
    pix.convertFromImage(alpha_image);
  }
  else
    pix.convertFromImage(mPreviewImage);
  mpPreviewLabel->setPixmap(pix);
  mpPreviewLabel->updateGeometry();
}
/** No descriptions */
void ImageFilterDialog::setTitle(const QString& title)
{
  if(!mpTitleLabel)
    return;
  mpTitleLabel->setText("<nobr><b>"+title+"</b></nobr>");
}
/** No descriptions */
QVBox* ImageFilterDialog::controlsVBox()
{
  return mpControlsVBox;
}
/** No descriptions */
bool ImageFilterDialog::stopped()
{
  return mStopped;
}
/** No descriptions */
void ImageFilterDialog::setStopped(bool status)
{
  mStopped = status;
}
/** No descriptions */
void ImageFilterDialog::slotStop()
{
  mStopped = true;
}
/** No descriptions */
void ImageFilterDialog::slotContinousUpdate(bool on)
{
  mpUpdateButton->setEnabled(!on);
  if(on)
    slotUpdatePreview();
}
/** No descriptions */
void ImageFilterDialog::accept()
{
  saveConfig();
  QDialog::accept();
}
/** No descriptions */
void ImageFilterDialog::saveConfig()
{
}
/** No descriptions */
void ImageFilterDialog::setContinousUpdate(bool state)
{
  mpUpdateCheckBox->setChecked(state);
}
/** No descriptions */
bool ImageFilterDialog::continousUpdate()
{
  return mpUpdateCheckBox->isChecked();
}
/** No descriptions */
void ImageFilterDialog::showContinousUpdate(bool state)
{
  if(state)
    mpUpdateHBox->show();
  else
    mpUpdateHBox->hide();
}
/** No descriptions */
QImage* ImageFilterDialog::originalImage()
{
  return mpOrigImage;
}
/** No descriptions */
QImage* ImageFilterDialog::previewImage()
{
  return &mPreviewImage;
}
